/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup.weka;

import adams.core.classmanager.ClassManager;
import adams.gui.core.BaseComboBox;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupOptionPanel;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.weka.AbstractOutputPanel;
import adams.gui.tools.wekamultiexperimenter.setup.weka.ArffOutputPanel;
import adams.gui.tools.wekamultiexperimenter.setup.weka.CustomOutputPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import weka.experiment.ResultListener;

public class OutputPanel
extends AbstractSetupOptionPanel {
    private static final long serialVersionUID = 5858138358135989633L;
    protected HashMap<String, AbstractOutputPanel> m_Panels;
    protected JPanel m_PanelComboBox;
    protected BaseComboBox m_ComboBoxOutput;
    protected AbstractOutputPanel m_Panel;

    @Override
    protected void initialize() {
        String[] panels;
        super.initialize();
        this.m_Panels = new HashMap();
        for (String cls : panels = AbstractOutputPanel.getPanels()) {
            try {
                AbstractOutputPanel panel = (AbstractOutputPanel)((Object)ClassManager.getSingleton().forName(cls).newInstance());
                this.m_Panels.put(panel.getOutputName(), panel);
            }
            catch (Exception e) {
                this.logError("Failed to instantiate output panel class: " + cls, "Output panels");
            }
        }
    }

    protected void initGUI() {
        super.initGUI();
        this.m_Panel = new ArffOutputPanel();
        this.add((Component)((Object)this.m_Panel), "Center");
        Object[] names = this.m_Panels.keySet().toArray(new String[this.m_Panels.size()]);
        Arrays.sort(names);
        this.m_ComboBoxOutput = new BaseComboBox(names);
        this.m_ComboBoxOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.m_Panel = OutputPanel.this.m_Panels.get((String)OutputPanel.this.m_ComboBoxOutput.getSelectedItem());
                OutputPanel.this.removeAll();
                OutputPanel.this.add(OutputPanel.this.m_PanelComboBox, "West");
                OutputPanel.this.add((Component)((Object)OutputPanel.this.m_Panel), "Center");
                OutputPanel.this.invalidate();
                OutputPanel.this.revalidate();
                OutputPanel.this.repaint();
                OutputPanel.this.modified();
            }
        });
        this.m_PanelComboBox = new JPanel(new FlowLayout(0));
        this.m_PanelComboBox.add((Component)this.m_ComboBoxOutput);
        this.add(this.m_PanelComboBox, "West");
        this.m_ComboBoxOutput.setSelectedItem((Object)this.m_Panel.getOutputName());
    }

    @Override
    public void setOwner(AbstractSetupPanel value) {
        super.setOwner(value);
        for (AbstractOutputPanel panel : this.m_Panels.values()) {
            panel.setOwner(value);
        }
    }

    public void setResultListener(ResultListener value) {
        AbstractOutputPanel match = null;
        String custom = null;
        for (AbstractOutputPanel panel : this.m_Panels.values()) {
            if (panel instanceof CustomOutputPanel) {
                custom = panel.getOutputName();
                continue;
            }
            if (!panel.handlesResultListener(value)) continue;
            match = panel;
            break;
        }
        if (match == null && custom != null) {
            match = this.m_Panels.get(custom);
        }
        if (match == null) {
            throw new IllegalArgumentException("Cannot handle ResultListener: " + value.getClass().getName());
        }
        this.m_ComboBoxOutput.setSelectedItem((Object)match.getOutputName());
        match.setResultListener(value);
    }

    public ResultListener getResultListener() {
        return this.m_Panel.getResultListener();
    }
}

