/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectexport;

import adams.core.logging.LoggingHelper;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import java.io.File;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffSaver;
import weka.core.converters.ConverterUtils;

public class WekaInstancesExporter
extends AbstractObjectExporter {
    private static final long serialVersionUID = 4899389310274830738L;

    public String getFormatDescription() {
        return "ARFF files";
    }

    public String[] getFormatExtensions() {
        return new ArffSaver().getFileExtensions();
    }

    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(Instances.class, (Class)cls) || ClassLocator.hasInterface(Instance.class, (Class)cls);
    }

    protected String doExport(Object obj, File file) {
        try {
            if (obj instanceof Instances) {
                ConverterUtils.DataSink.write((String)file.getAbsolutePath(), (Instances)((Instances)obj));
                return null;
            }
            Instance inst = (Instance)obj;
            if (inst.dataset() != null) {
                Instances data = new Instances(inst.dataset());
                data.add((Instance)inst.copy());
                ConverterUtils.DataSink.write((String)file.getAbsolutePath(), (Instances)data);
                return null;
            }
            return "Instance has no dataset associated, cannot export as ARFF!";
        }
        catch (Exception e) {
            return "Failed to write Instances to '" + file + "'!\n" + LoggingHelper.throwableToString((Throwable)e);
        }
    }
}

