/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.ArrayHistogram;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import adams.gui.core.Undo;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerPanelWithContainerList;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.instance.AbstractInstancePaintlet;
import adams.gui.visualization.instance.HistogramFactory;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerList;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstanceLinePaintlet;
import adams.gui.visualization.instance.InstancePointHitDetector;
import adams.gui.visualization.instance.InstanceZoomOverviewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Instances;

public class InstancePanel
extends DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer>
implements PaintListener,
TipTextCustomizer,
AntiAliasingSupporter,
HitDetectorSupporter<InstancePointHitDetector> {
    private static final long serialVersionUID = 7985845939008731534L;
    protected AbstractInstancePaintlet m_InstancePaintlet;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected Undo m_Undo;
    protected boolean m_AdjustToVisibleData;
    protected InstancePointHitDetector m_InstancePointHitDetector;
    protected int m_ToolTipMaxColumns;
    protected int m_ToolTipMaxRows;
    protected InstanceZoomOverviewPanel m_PanelZoomOverview;
    protected SpreadSheetFileChooser m_FileChooser;
    protected List<SpreadSheetDialog> m_ViewDialogs;
    protected HistogramFactory.SetupDialog m_HistogramSetup;

    public InstancePanel() {
    }

    public InstancePanel(String title) {
        super(title);
    }

    protected void initialize() {
        this.m_Undo = null;
        this.m_AdjustToVisibleData = true;
        this.m_HistogramSetup = null;
        super.initialize();
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    protected InstanceContainerManager newContainerManager() {
        return new InstanceContainerManager((ContainerListManager<InstanceContainerManager>)this);
    }

    public AbstractInstancePaintlet getContainerPaintlet() {
        return this.m_InstancePaintlet;
    }

    public InstancePointHitDetector getHitDetector() {
        return this.m_InstancePointHitDetector;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.m_ToolTipMaxColumns = props.getInteger("Plot.ToolTip.MaxColumns", Integer.valueOf(80));
        this.m_ToolTipMaxRows = props.getInteger("Plot.ToolTip.MaxRows", Integer.valueOf(40));
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", Boolean.valueOf(false)));
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        panel.setPreferredSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        this.m_SidePanel.add((Component)panel, "South");
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
        this.m_InstancePaintlet = new InstanceLinePaintlet();
        this.m_InstancePaintlet.setStrokeThickness(props.getDouble("Plot.StrokeThickness", Double.valueOf(1.0)).floatValue());
        ((AntiAliasingSupporter)this.m_InstancePaintlet).setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", Boolean.valueOf(true)).booleanValue());
        this.m_InstancePaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.X, Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.Y, Color.DARK_GRAY));
        this.m_InstancePointHitDetector = new InstancePointHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        try {
            ((InstanceContainerManager)this.getContainerManager()).setColorProvider((ColorProvider)OptionUtils.forAnyCommandLine(ColorProvider.class, (String)props.getProperty("Plot.ColorProvider", DefaultColorProvider.class.getName())));
        }
        catch (Exception e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + " - Failed to set the color provider:");
            ((InstanceContainerManager)this.getContainerManager()).setColorProvider((ColorProvider)new DefaultColorProvider());
        }
        this.m_PanelZoomOverview = new InstanceZoomOverviewPanel();
        this.m_PlotWrapperPanel.add((Component)((Object)this.m_PanelZoomOverview), (Object)"South");
        this.m_PanelZoomOverview.setDataContainerPanel((DataContainerPanel)this);
    }

    protected InstanceContainerList createContainerList() {
        InstanceContainerList result = new InstanceContainerList();
        result.setTitle("Instances");
        result.setManager((InstanceContainerManager)this.getContainerManager());
        result.setAllowSearch(this.getProperties().getBoolean("ContainerList.AllowSearch", Boolean.valueOf(false)));
        result.setPopupMenuSupplier((ContainerListPopupMenuSupplier)this);
        result.addTableModelListener(e -> {
            ContainerTable table = result.getTable();
            if (table.getRowCount() > 0 && table.getSelectedRowCount() == 0) {
                SwingUtilities.invokeLater(() -> table.getSelectionModel().addSelectionInterval(0, 0));
            }
        });
        return result;
    }

    public AbstractContainerManager getSequenceManager() {
        return this.m_Manager;
    }

    public void setUndo(Undo value) {
        this.m_Undo = value;
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void prepareUpdate() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = 0.0;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < ((InstanceContainerManager)this.getContainerManager()).count(); ++i) {
            List points;
            if (this.m_AdjustToVisibleData && !((InstanceContainerManager)this.getContainerManager()).isVisible(i) || (points = ((InstanceContainer)((InstanceContainerManager)this.getContainerManager()).get(i)).getData().toList()).size() == 0) continue;
            if (InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(0))).getX()) < minX) {
                minX = InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(0))).getX());
            }
            if (InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(points.size() - 1))).getX()) > maxX) {
                maxX = InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(points.size() - 1))).getX());
            }
            for (InstancePoint point : points) {
                if (InstancePoint.toDouble((Double)point.getY()) > maxY) {
                    maxY = InstancePoint.toDouble((Double)point.getY());
                }
                if (!(InstancePoint.toDouble((Double)point.getY()) < minY)) continue;
                minY = InstancePoint.toDouble((Double)point.getY());
            }
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    public boolean supportsStoreColorInReport() {
        return true;
    }

    public void storeColorInReport(int[] indices, String name) {
        Field field = new Field(name, DataType.STRING);
        for (int index : indices) {
            InstanceContainer cont = (InstanceContainer)((InstanceContainerManager)this.getContainerManager()).get(index);
            cont.getData().getReport().addField((AbstractField)field);
            cont.getData().getReport().setValue((AbstractField)field, (Object)ColorHelper.toHex((Color)cont.getColor()));
        }
    }

    public boolean supportsStoreValueInReport() {
        return true;
    }

    public void storeValueInReport(int[] indices, AbstractField field, Object value) {
        ((InstanceContainerManager)this.getContainerManager()).startUpdate();
        for (int index : indices) {
            InstanceContainer cont = (InstanceContainer)((InstanceContainerManager)this.getContainerManager()).get(index);
            cont.getData().getReport().addField(field);
            cont.getData().getReport().setValue(field, value);
        }
        ((InstanceContainerManager)this.getContainerManager()).finishUpdate();
    }

    public void showHistogram(List<InstanceContainer> data) {
        if (this.m_HistogramSetup == null) {
            this.m_HistogramSetup = this.getParentDialog() != null ? HistogramFactory.getSetupDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog(this.getParentFrame(), true);
        }
        this.m_HistogramSetup.setLocationRelativeTo((Component)((Object)this));
        this.m_HistogramSetup.setVisible(true);
        if (this.m_HistogramSetup.getResult() != 0) {
            return;
        }
        HistogramFactory.Dialog dialog = this.getParentDialog() != null ? HistogramFactory.getDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog(this.getParentFrame(), false);
        for (int i = 0; i < data.size(); ++i) {
            Instance inst = data.get(i).getData();
            dialog.add((ArrayHistogram)this.m_HistogramSetup.getCurrent(), inst, data.get(i).getID());
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    public void saveInstance(InstanceContainer cont) {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        Instance inst = cont.getData();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(inst.toSpreadSheet(), this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save instance to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void viewInstance(InstanceContainer cont) {
        if (this.m_ViewDialogs == null) {
            this.m_ViewDialogs = new ArrayList<SpreadSheetDialog>();
        }
        Instance isnt = cont.getData();
        SpreadSheet sheet = isnt.toSpreadSheet();
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        this.m_ViewDialogs.add(dialog);
        dialog.setTitle("Instance: " + cont.getDisplayID());
        dialog.setSize(GUIHelper.getInteger((String)"DefaultSmallDialog.Height", (Integer)400).intValue(), GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setSpreadSheet(sheet);
        dialog.setVisible(true);
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelZoomOverview.setVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelZoomOverview.isVisible();
    }

    public InstanceZoomOverviewPanel getZoomOverviewPanel() {
        return this.m_PanelZoomOverview;
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    public AbstractInstancePaintlet getDataPaintlet() {
        return this.m_InstancePaintlet;
    }

    public void setDataPaintlet(Paintlet value) {
        this.removePaintlet((Paintlet)this.m_InstancePaintlet);
        this.m_InstancePaintlet = (AbstractInstancePaintlet)value;
        this.m_InstancePaintlet.setPanel((PaintablePanel)this);
        this.addPaintlet((Paintlet)this.m_InstancePaintlet);
    }

    public void setAntiAliasingEnabled(boolean value) {
        if (this.m_InstancePaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_InstancePaintlet).setAntiAliasingEnabled(value);
        }
        if (this.m_PanelZoomOverview.getContainerPaintlet() instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_PanelZoomOverview.getContainerPaintlet()).setAntiAliasingEnabled(value);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_InstancePaintlet instanceof AntiAliasingSupporter && ((AntiAliasingSupporter)this.m_InstancePaintlet).isAntiAliasingEnabled();
    }

    public Instances getInstances() {
        Instances result = null;
        List<InstanceContainer> list = ((InstanceContainerManager)this.getContainerManager()).getAllVisible();
        for (int i = 0; i < list.size(); ++i) {
            Instance inst = list.get(i).getData();
            if (result == null) {
                result = inst.getDatasetHeader();
            }
            result.add(inst.toInstance());
        }
        return result;
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String result = tiptext;
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_InstancePointHitDetector.detect(event);
        if (hit != null) {
            result = GUIHelper.processTipText((String)hit, (int)this.m_ToolTipMaxColumns, (int)this.m_ToolTipMaxRows);
        }
        return result;
    }

    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton((AbstractDatabaseConnection)this.getDatabaseConnection());
    }

    protected void postUpdate() {
        super.postUpdate();
        if (this.m_PanelZoomOverview != null) {
            this.m_PanelZoomOverview.update();
        }
    }

    public void cleanUp() {
        if (this.m_InstancePointHitDetector != null) {
            this.m_InstancePointHitDetector.cleanUp();
            this.m_InstancePointHitDetector = null;
        }
        if (this.m_ViewDialogs != null) {
            for (SpreadSheetDialog dialog : this.m_ViewDialogs) {
                dialog.dispose();
            }
            this.m_ViewDialogs.clear();
            this.m_ViewDialogs = null;
        }
        if (this.m_HistogramSetup != null) {
            this.m_HistogramSetup.dispose();
            this.m_HistogramSetup = null;
        }
        super.cleanUp();
    }
}

