/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.gui.core.SortableAndSearchableTable;
import adams.gui.visualization.instances.InstancesTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributeValueCellRenderer
extends DefaultTableCellRenderer {
    static final long serialVersionUID = 9195794493301191171L;
    protected Color m_MissingColor;
    protected Color m_MissingColorSelected;

    public AttributeValueCellRenderer() {
        this(new Color(223, 223, 223), new Color(192, 192, 192));
    }

    public AttributeValueCellRenderer(Color missingColor, Color missingColorSelected) {
        this.m_MissingColor = missingColor;
        this.m_MissingColorSelected = missingColorSelected;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        InstancesTableModel model = null;
        SortableAndSearchableTable stable = null;
        if (table instanceof SortableAndSearchableTable) {
            stable = (SortableAndSearchableTable)table;
            if (((SortableAndSearchableTable)table).getUnsortedModel() instanceof InstancesTableModel) {
                model = (InstancesTableModel)((SortableAndSearchableTable)table).getUnsortedModel();
            }
        }
        if (model != null) {
            if (row >= 0) {
                if (model.isMissingAt(stable.getActualRow(row), column)) {
                    this.setToolTipText("missing");
                    if (isSelected) {
                        result.setBackground(this.m_MissingColorSelected);
                    } else {
                        result.setBackground(this.m_MissingColor);
                    }
                } else {
                    this.setToolTipText(null);
                    if (isSelected) {
                        result.setBackground(table.getSelectionBackground());
                    } else {
                        result.setBackground(Color.WHITE);
                    }
                }
                if (model.getType(stable.getActualRow(row), column) == 0) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                if (table.getColumnModel().getSelectionModel().isSelectedIndex(column)) {
                    result.setBackground(UIManager.getColor("TableHeader.background").darker());
                } else {
                    result.setBackground(UIManager.getColor("TableHeader.background"));
                }
            }
        }
        return result;
    }
}

