/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.option.AbstractOptionHandler;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.ProcessCell;
import java.awt.Component;
import weka.core.Instances;

public abstract class AbstractProcessCell
extends AbstractOptionHandler
implements ProcessCell {
    private static final long serialVersionUID = -1050881505327794503L;

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return true;
    }

    protected String check(InstancesTablePopupMenuItemHelper.TableState state) {
        if (state.table == null) {
            return "No source table available!";
        }
        if (state.actRow < 0) {
            return "Negative row index!";
        }
        Instances data = state.table.getInstances();
        if (state.actRow >= data.numInstances()) {
            return "Row index too large: " + (state.actRow + 1) + " > " + data.numInstances();
        }
        if (state.actCol < 0) {
            return "Negative column index!";
        }
        if (state.actCol >= data.numAttributes()) {
            return "Column index too large: " + (state.actCol + 1) + " > " + data.numAttributes();
        }
        return null;
    }

    protected abstract boolean doProcessCell(InstancesTablePopupMenuItemHelper.TableState var1);

    @Override
    public boolean processCell(InstancesTablePopupMenuItemHelper.TableState state) {
        boolean result;
        String error = this.check(state);
        boolean bl = result = error == null;
        if (result) {
            result = this.doProcessCell(state);
        } else {
            GUIHelper.showErrorMessage((Component)((Object)state.table), (String)("Failed to process cell " + (state.actRow + 1) + "/" + (state.actCol + 1) + "\n" + error));
        }
        return result;
    }
}

