/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractColumnStatistic;
import adams.data.spreadsheet.colstatistic.Mean;
import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.instances.instancestable.AbstractProcessColumn;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.ml.data.InstancesView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import weka.core.Instances;

public class ColumnStatistic
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to calculate statistics for a column.";
    }

    @Override
    public String getMenuItem() {
        return "Column statistics...";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    @Override
    protected boolean doProcessColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractColumnStatistic.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractColumnStatistic last = (AbstractColumnStatistic)state.table.getLastSetup(this.getClass(), true, false);
        if (last == null) {
            last = new Mean();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)state.table)));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractColumnStatistic)setup.getCurrent();
        state.table.addLastSetup(this.getClass(), true, false, last);
        Instances data = state.table.toInstances(state.range, true);
        SpreadSheet stats = last.generate((SpreadSheet)new InstancesView(data), state.actCol);
        if (stats == null) {
            if (last.hasLastError()) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Failed to calculate statistics for column #" + (state.actCol + 1) + ": " + last.getLastError()));
            } else {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Failed to calculate statistics for column #" + (state.actCol + 1) + "!"));
            }
        } else {
            SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Statistics for column #" + (state.actCol + 1) + "/" + data.attribute(state.actCol).name());
            dialog.setSpreadSheet(stats);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return stats != null;
    }
}

