/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.ClassLister;
import adams.core.classmanager.ClassManager;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.instances.instancestable.PlotSelectedRows;
import adams.gui.visualization.instances.instancestable.ProcessCell;
import adams.gui.visualization.instances.instancestable.ProcessColumn;
import adams.gui.visualization.instances.instancestable.ProcessRow;
import adams.gui.visualization.instances.instancestable.ProcessSelectedRows;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class InstancesTablePopupMenuItemHelper {
    public static TableState getState(InstancesTable table, MouseEvent e, TableRowRange range) {
        TableState result = new TableState();
        result.table = table;
        result.range = range;
        result.selRow = table.getSelectedRow();
        if (result.selRow != -1) {
            result.actRow = table.getActualRow(result.selRow);
        }
        result.selRows = table.getSelectedRows();
        result.actRows = new int[result.selRows.length];
        for (int i = 0; i < result.selRows.length; ++i) {
            result.actRows[i] = table.getActualRow(result.selRows[i]);
        }
        result.selCol = table.columnAtPoint(e.getPoint());
        result.actCol = result.selCol - 1;
        if (table.getShowAttributeWeights()) {
            --result.actCol;
        }
        return result;
    }

    protected static List<InstancesTablePopupMenuItem> getItems(Class cls) {
        String[] classes;
        ArrayList<InstancesTablePopupMenuItem> result = new ArrayList<InstancesTablePopupMenuItem>();
        for (String c : classes = ClassLister.getSingleton().getClassnames(cls)) {
            try {
                result.add((InstancesTablePopupMenuItem)ClassManager.getSingleton().forName(c).newInstance());
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append("Failed to instantiate InstancesTable menu item: " + c, (Throwable)e);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    protected static void addAction(TableState state, boolean isRow, JMenuItem menuitem, InstancesTablePopupMenuItem item) {
        if (isRow) {
            if (item instanceof PlotSelectedRows) {
                boolean enabled;
                PlotSelectedRows plotSelRows = (PlotSelectedRows)item;
                menuitem.addActionListener(e -> ((PlotSelectedRows)item).plotSelectedRows(state));
                boolean bl = enabled = state.actRows.length >= plotSelRows.minNumRows();
                if (plotSelRows.maxNumRows() != -1) {
                    enabled = enabled && state.actRows.length <= plotSelRows.maxNumRows();
                }
                menuitem.setEnabled(enabled);
            } else if (item instanceof PlotRow) {
                menuitem.addActionListener(e -> ((PlotRow)item).plotRow(state));
                menuitem.setEnabled(state.actRows.length <= 1);
            } else if (item instanceof ProcessSelectedRows) {
                boolean enabled;
                ProcessSelectedRows procSelRows = (ProcessSelectedRows)item;
                menuitem.addActionListener(e -> ((ProcessSelectedRows)item).processSelectedRows(state));
                boolean bl = enabled = state.actRows.length >= procSelRows.minNumRows();
                if (procSelRows.maxNumRows() != -1) {
                    enabled = enabled && state.actRows.length <= procSelRows.maxNumRows();
                }
                menuitem.setEnabled(enabled);
            } else if (item instanceof ProcessRow) {
                menuitem.addActionListener(e -> ((ProcessRow)item).processRow(state));
                menuitem.setEnabled(state.actRows.length <= 1);
            } else if (item instanceof ProcessCell) {
                menuitem.setEnabled(state.selRow >= 0 && state.selCol >= 0);
                menuitem.addActionListener(e -> ((ProcessCell)item).processCell(state));
            }
        } else if (item instanceof PlotColumn) {
            menuitem.setEnabled(((PlotColumn)item).handlesRowRange(state.range));
            menuitem.addActionListener(e -> ((PlotColumn)item).plotColumn(state));
        } else if (item instanceof ProcessColumn) {
            menuitem.setEnabled(((ProcessColumn)item).handlesRowRange(state.range));
            menuitem.addActionListener(e -> ((ProcessColumn)item).processColumn(state));
        }
    }

    protected static void addToPopupMenu(TableState state, boolean isRow, JPopupMenu menu, List<InstancesTablePopupMenuItem> items) {
        if (items.size() == 0) {
            return;
        }
        if (menu.getComponent(menu.getComponentCount() - 1) instanceof JMenuItem) {
            menu.addSeparator();
        }
        for (InstancesTablePopupMenuItem item : items) {
            if (!item.isAvailable(state)) continue;
            JMenuItem menuitem = new JMenuItem(item.getMenuItem());
            if (item.getIconName() != null) {
                menuitem.setIcon(GUIHelper.getIcon((String)item.getIconName()));
            }
            InstancesTablePopupMenuItemHelper.addAction(state, isRow, menuitem, item);
            menu.add(menuitem);
        }
    }

    public static void addToPopupMenu(TableState state, JPopupMenu menu, boolean isRow) {
        menu.addSeparator();
        if (isRow) {
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, true, menu, InstancesTablePopupMenuItemHelper.getItems(PlotRow.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, true, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessRow.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, true, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessSelectedRows.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, true, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessCell.class));
        } else {
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, false, menu, InstancesTablePopupMenuItemHelper.getItems(PlotColumn.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(state, false, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessColumn.class));
        }
    }

    public static class TableState {
        public InstancesTable table = null;
        public TableRowRange range = TableRowRange.ALL;
        public int selRow = -1;
        public int actRow = -1;
        public int[] selRows = new int[0];
        public int[] actRows = new int[0];
        public int selCol = -1;
        public int actCol = -1;
    }
}

