/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Utils;
import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.visualization.instances.instancestable.AbstractProcessSelectedRows;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.ProcessRow;
import java.awt.Container;
import weka.core.Instances;

public class InvestigatorAsNewDataset
extends AbstractProcessSelectedRows
implements ProcessRow {
    private static final long serialVersionUID = 8866236994813131751L;

    public String globalInfo() {
        return "Allows the user to add the selected rows as new dataset in the Investigator.";
    }

    @Override
    public String getIconName() {
        return "new.gif";
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return GUIHelper.getParent((Container)((Object)state.table), InvestigatorPanel.class) != null;
    }

    @Override
    protected String getDefaultMenuItem() {
        return "As new dataset...";
    }

    @Override
    public int minNumRows() {
        return 1;
    }

    @Override
    public int maxNumRows() {
        return -1;
    }

    @Override
    protected boolean doProcessSelectedRows(InstancesTablePopupMenuItemHelper.TableState state) {
        InvestigatorPanel panel = (InvestigatorPanel)((Object)GUIHelper.getParent((Container)((Object)state.table), InvestigatorPanel.class));
        Instances dataNew = state.table.toInstances(TableRowRange.SELECTED);
        dataNew.setRelationName(dataNew.relationName() + ":" + Utils.arrayToString((Object)Utils.adjustIndices((int[])state.actRows, (int)1)));
        MemoryContainer newCont = new MemoryContainer(dataNew);
        panel.getData().add(newCont);
        panel.logMessage("Added new subset from rows: " + Utils.arrayToString((Object)Utils.adjustIndices((int[])state.actRows, (int)1)));
        panel.fireDataChange(new WekaInvestigatorDataEvent(panel, 2, panel.getData().size() - 1));
        return true;
    }

    @Override
    public boolean processRow(InstancesTablePopupMenuItemHelper.TableState state) {
        return this.processSelectedRows(state);
    }
}

