/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.base.BaseText;
import adams.core.option.AbstractOptionHandler;
import adams.data.weka.WekaAttributeRange;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.control.Trigger;
import adams.flow.core.Actor;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.source.StorageValue;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.CollectionToSequence;
import adams.flow.transformer.GetArrayElement;
import adams.flow.transformer.IncVariable;
import adams.flow.transformer.MakePlotContainer;
import adams.flow.transformer.SetVariable;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.instances.instancestable.PlotSelectedRows;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.SwingWorker;
import weka.core.Instances;

public class SimplePlot
extends AbstractOptionHandler
implements PlotColumn,
PlotRow,
PlotSelectedRows {
    private static final long serialVersionUID = -5624002368001818142L;
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_PLOT = "plot";
    public static final int MAX_POINTS = 1000;

    public String globalInfo() {
        return "Allows to generate a simple plot from a instances row or column";
    }

    @Override
    public String getMenuItem() {
        return "Simple plot...";
    }

    @Override
    public String getIconName() {
        return "plot.gif";
    }

    @Override
    public boolean isAvailable(InstancesTablePopupMenuItemHelper.TableState state) {
        return true;
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    protected Properties promptParameters(InstancesTable table, boolean isColumn) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)((Object)table)) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)((Object)table)), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)((Object)table)), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        if (!isColumn) {
            panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.RANGE);
            panel.setLabel(KEY_COLUMNS, "Columns");
            panel.setHelp(KEY_COLUMNS, "The columns to use for the plot");
        }
        panel.addPropertyType(KEY_PLOT, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_PLOT, "Plot");
        panel.setHelp(KEY_PLOT, "How to display the data");
        panel.setChooser(KEY_PLOT, (AbstractChooserPanel)new GenericObjectEditorPanel(Actor.class, (Object)new adams.flow.sink.SimplePlot(), false));
        if (!isColumn) {
            panel.setPropertyOrder(new String[]{KEY_COLUMNS, KEY_PLOT});
        }
        adams.flow.sink.SimplePlot defPlot = new adams.flow.sink.SimplePlot();
        defPlot.setNoToolTips(true);
        defPlot.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        Properties last = new Properties();
        if (!isColumn) {
            last.setProperty(KEY_COLUMNS, "first-last");
        }
        last.setObject(KEY_PLOT, (Object)defPlot);
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(this.getClass(), true, !isColumn);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected void createPlot(final InstancesTable table, final boolean isColumn, final List<Double>[] list, final String title, final String[] titles) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                flow.setDefaultCloseOperation(2);
                adams.flow.standalone.SetVariable svInit = new adams.flow.standalone.SetVariable();
                svInit.setVariableName(new VariableName("index"));
                svInit.setVariableValue(new BaseText("0"));
                flow.add((Actor)svInit);
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add((Actor)sv);
                flow.add((Actor)new ArrayToSequence());
                IncVariable inc = new IncVariable();
                inc.setVariableName(new VariableName("index"));
                inc.setIncrementType(IncVariable.IncrementType.INTEGER);
                inc.setIntegerIncrement(1);
                flow.add((Actor)inc);
                Trigger trigTitle = new Trigger();
                trigTitle.setName("get title");
                flow.add((Actor)trigTitle);
                StorageValue svalue = new StorageValue();
                svalue.setStorageName(new StorageName("titles"));
                trigTitle.add((Actor)svalue);
                GetArrayElement get = new GetArrayElement();
                get.getOptionManager().setVariableForProperty("index", "index");
                trigTitle.add((Actor)get);
                SetVariable svTitle = new SetVariable();
                svTitle.setVariableName(new VariableName("title"));
                trigTitle.add((Actor)svTitle);
                flow.add((Actor)new CollectionToSequence());
                MakePlotContainer mpc = new MakePlotContainer();
                mpc.getOptionManager().setVariableForProperty("plotName", "title");
                flow.add((Actor)mpc);
                Properties props = (Properties)table.getLastSetup(SimplePlot.this.getClass(), true, !isColumn);
                adams.flow.sink.SimplePlot lastPlot = (adams.flow.sink.SimplePlot)props.getObject(SimplePlot.KEY_PLOT, adams.flow.sink.SimplePlot.class);
                adams.flow.sink.SimplePlot plot = (adams.flow.sink.SimplePlot)ObjectCopyHelper.copyObject((Object)lastPlot);
                plot.setShortTitle(true);
                plot.setShowSidePanel(titles.length > 1);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add((Actor)plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), (Object)list);
                flow.getStorage().put(new StorageName("titles"), (Object)titles);
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    protected void plot(InstancesTablePopupMenuItemHelper.TableState state, boolean isColumn, int index, int[] indices) {
        String[] titles;
        String title;
        ArrayList[] list;
        int i;
        int numPoints;
        Instances data = isColumn ? state.table.toInstances(state.range, true) : state.table.getInstances();
        int n = numPoints = isColumn ? data.numInstances() : data.numAttributes();
        if (numPoints > 1000) {
            String newPoints = GUIHelper.showInputDialog(null, (String)"More than 1000 data points to plot - enter sample size:", (String)("" + numPoints));
            if (newPoints == null) {
                return;
            }
            if (!Utils.isInteger((String)newPoints)) {
                return;
            }
            numPoints = Integer.parseInt(newPoints) != numPoints ? Integer.parseInt(newPoints) : -1;
        } else {
            numPoints = -1;
        }
        Properties last = this.promptParameters(state.table, isColumn);
        if (last == null) {
            return;
        }
        state.table.addLastSetup(this.getClass(), true, !isColumn, last);
        ArrayList[] tmp = indices == null ? new ArrayList[]{new ArrayList()} : new ArrayList[indices.length];
        boolean sorted = false;
        boolean asc = state.table.isAscending();
        if (isColumn) {
            sorted = state.table.getSortColumn() == state.selCol;
            for (i = 0; i < data.numInstances(); ++i) {
                if (!data.attribute(state.actCol).isNumeric() || data.instance(i).isMissing(state.actCol)) continue;
                tmp[0].add(data.instance(i).value(state.actCol));
            }
        } else {
            int[] rows = indices == null ? new int[index] : indices;
            WekaAttributeRange columns = new WekaAttributeRange(last.getProperty(KEY_COLUMNS, "first-last"));
            columns.setData(data);
            int[] cols = columns.getIntIndices();
            for (int n2 = 0; n2 < rows.length; ++n2) {
                tmp[n2] = new ArrayList();
                int row = rows[n2];
                for (i = 0; i < cols.length; ++i) {
                    if (!data.attribute(cols[i]).isNumeric() || data.instance(row).isMissing(cols[i])) continue;
                    tmp[n2].add(data.instance(row).value(cols[i]));
                }
            }
        }
        if (numPoints > -1) {
            list = new ArrayList[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                numPoints = Math.min(numPoints, tmp[i].size());
                Collections.shuffle(tmp[i], new Random(1L));
                list[i] = tmp[i].subList(0, numPoints);
            }
        } else {
            list = tmp;
        }
        if (sorted) {
            for (i = 0; i < list.length; ++i) {
                Collections.sort(list[i]);
                if (asc) continue;
                Collections.reverse(list[i]);
            }
        }
        if (isColumn) {
            title = "Column " + (index + 1) + "/" + data.attribute(index).name();
            titles = new String[]{title};
        } else if (indices == null) {
            title = "Row " + (index + 1);
            titles = new String[]{title};
        } else {
            titles = new String[indices.length];
            int[] actRows = Utils.adjustIndices((int[])indices, (int)1);
            for (i = 0; i < indices.length; ++i) {
                titles[i] = "Row " + actRows[i];
            }
            title = "Row" + (actRows.length != 1 ? "s" : "") + " " + Shortening.shortenMiddle((String)Utils.arrayToString((Object)actRows), (int)40);
        }
        this.createPlot(state.table, isColumn, list, title, titles);
    }

    @Override
    public boolean plotColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, true, state.actCol, null);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRow, null);
        return true;
    }

    @Override
    public int minNumRows() {
        return 1;
    }

    @Override
    public int maxNumRows() {
        return -1;
    }

    @Override
    public boolean plotSelectedRows(InstancesTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRows[0], state.actRows);
        return true;
    }
}

