/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.capabilities.Capability;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class WekaConverter {
    public static Instances toInstances(Dataset data) throws Exception {
        SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
        conv.setInput(data);
        String msg = conv.convert();
        if (msg != null) {
            throw new Exception("Failed to convert Dataset to Instances: " + msg);
        }
        Instances result = (Instances)conv.getOutput();
        conv.cleanUp();
        int[] classes = data.getClassAttributeIndices();
        if (classes.length == 1) {
            result.setClassIndex(classes[0]);
        }
        return result;
    }

    public static Dataset toDataset(Instances data) throws Exception {
        WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
        conv.setSpreadSheetType((SpreadSheet)new DefaultDataset());
        String msg = conv.convert();
        if (msg != null) {
            throw new Exception("Failed to convert Instances to Dataset: " + msg);
        }
        Dataset result = (Dataset)conv.getOutput();
        if (data.classIndex() > -1) {
            result.setClassAttribute(data.classIndex(), true);
        }
        return result;
    }

    public static Instance toInstance(Instances data, Row row) throws Exception {
        double[] values = new double[data.numAttributes()];
        block6: for (int i = 0; i < data.numAttributes(); ++i) {
            Cell cell;
            values[i] = Utils.missingValue();
            if (!row.hasCell(i) || (cell = row.getCell(i)).isMissing()) continue;
            Attribute att = data.attribute(i);
            switch (att.type()) {
                case 0: {
                    values[i] = cell.toDouble();
                    continue block6;
                }
                case 3: {
                    values[i] = cell.toAnyDateType().getTime();
                    continue block6;
                }
                case 1: {
                    values[i] = att.indexOfValue(cell.getContent());
                    continue block6;
                }
                case 2: {
                    values[i] = att.addStringValue(cell.getContent());
                    continue block6;
                }
                default: {
                    throw new Exception("Unhandled Weka attribute type: " + Attribute.typeToString((Attribute)att));
                }
            }
        }
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(data);
        return result;
    }

    protected static void transferCapability(Capabilities fromCaps, Capabilities.Capability fromCap, adams.ml.capabilities.Capabilities toCaps, Capability toCap) {
        if (fromCaps.handles(fromCap)) {
            if (toCap == null) {
                throw new IllegalStateException("Unsupported attribute capability: " + fromCap);
            }
            toCaps.enable(toCap);
        }
        if (fromCaps.hasDependency(fromCap)) {
            toCaps.enableDependent(toCap);
        }
    }

    public static adams.ml.capabilities.Capabilities convertCapabilities(Capabilities caps) {
        adams.ml.capabilities.Capabilities result = new adams.ml.capabilities.Capabilities();
        if (caps.getMinimumNumberInstances() > 0) {
            result.setMinRows(caps.getMinimumNumberInstances());
        }
        if (caps.handles(Capabilities.Capability.NO_CLASS)) {
            result.setMinClassColumns(0);
            result.setMaxClassColumns(0);
        }
        WekaConverter.transferCapability(caps, Capabilities.Capability.MISSING_CLASS_VALUES, result, Capability.MISSING_CLASS_VALUE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.MISSING_VALUES, result, Capability.MISSING_ATTRIBUTE_VALUE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.NOMINAL_ATTRIBUTES, result, Capability.CATEGORICAL_ATTRIBUTE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.BINARY_ATTRIBUTES, result, Capability.CATEGORICAL_ATTRIBUTE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.UNARY_ATTRIBUTES, result, Capability.CATEGORICAL_ATTRIBUTE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.NUMERIC_ATTRIBUTES, result, Capability.NUMERIC_ATTRIBUTE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.DATE_ATTRIBUTES, result, Capability.DATETYPE_ATTRIBUTE);
        WekaConverter.transferCapability(caps, Capabilities.Capability.STRING_ATTRIBUTES, result, null);
        WekaConverter.transferCapability(caps, Capabilities.Capability.RELATIONAL_ATTRIBUTES, result, null);
        WekaConverter.transferCapability(caps, Capabilities.Capability.NOMINAL_CLASS, result, Capability.CATEGORICAL_CLASS);
        WekaConverter.transferCapability(caps, Capabilities.Capability.BINARY_CLASS, result, Capability.CATEGORICAL_CLASS);
        WekaConverter.transferCapability(caps, Capabilities.Capability.UNARY_CLASS, result, Capability.CATEGORICAL_CLASS);
        WekaConverter.transferCapability(caps, Capabilities.Capability.NUMERIC_CLASS, result, Capability.NUMERIC_CLASS);
        WekaConverter.transferCapability(caps, Capabilities.Capability.DATE_CLASS, result, Capability.DATETYPE_CLASS);
        WekaConverter.transferCapability(caps, Capabilities.Capability.STRING_CLASS, result, null);
        WekaConverter.transferCapability(caps, Capabilities.Capability.RELATIONAL_CLASS, result, null);
        return result;
    }
}

