/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.classification;

import adams.core.ObjectCopyHelper;
import adams.core.option.OptionUtils;
import adams.ml.capabilities.Capabilities;
import adams.ml.data.Dataset;
import adams.ml.data.WekaConverter;
import adams.ml.model.classification.AbstractClassifier;
import adams.ml.model.classification.ClassificationModel;
import adams.ml.model.classification.WekaClassificationModel;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instances;

public class WekaClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = -4086036132431888958L;
    protected Classifier m_Classifier;

    public String globalInfo() {
        return "Wraps around a Weka classifier that handles nominal classes (= classification).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new J48());
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.assign(WekaConverter.convertCapabilities(this.m_Classifier.getCapabilities()));
        return result;
    }

    protected ClassificationModel doBuildModel(Dataset data) throws Exception {
        Instances inst = WekaConverter.toInstances(data);
        Classifier classifier = (Classifier)ObjectCopyHelper.copyObject((Object)this.m_Classifier);
        if (classifier == null) {
            throw new Exception("Failed to create shallow copy of classifier: " + OptionUtils.getCommandLine((Object)this.m_Classifier));
        }
        classifier.buildClassifier(inst);
        return new WekaClassificationModel(classifier, data, inst);
    }
}

