/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.optimise.genetic.fitnessfunctions;

import adams.core.ObjectCopyHelper;
import adams.core.option.OptionUtils;
import adams.opt.optimise.OptData;
import adams.opt.optimise.OptVar;
import adams.opt.optimise.genetic.fitnessfunctions.AbstractWEKAFitnessFunction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Random;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.Remove;

public class AttributeSelection
extends AbstractWEKAFitnessFunction {
    private static final long serialVersionUID = 1967190416117903831L;

    @Override
    public String globalInfo() {
        return "Attribute selection";
    }

    public OptData getDataDef() {
        this.init();
        OptData odd = new OptData();
        for (int i = 0; i < this.m_Instances.numAttributes() - 1; ++i) {
            odd.add(new OptVar("" + i, 0.0, 1.0, true));
        }
        return odd;
    }

    protected int[] getWeights(OptData opd) {
        int[] weights = new int[this.getInstances().numAttributes() - 1];
        int cnt = 0;
        for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
            if (i == this.getInstances().classIndex()) continue;
            weights[cnt] = opd.get("" + cnt).intValue();
            ++cnt;
        }
        return weights;
    }

    public double evaluate(OptData opd) {
        this.init();
        int cnt = 0;
        int[] weights = this.getWeights(opd);
        Instances newInstances = new Instances(this.getInstances());
        for (int i = 0; i < this.getInstances().numInstances(); ++i) {
            Instance in = newInstances.instance(i);
            cnt = 0;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (a == this.getInstances().classIndex()) continue;
                if (weights[cnt++] == 0) {
                    in.setValue(a, 0.0);
                    continue;
                }
                in.setValue(a, in.value(a));
            }
        }
        Classifier newClassifier = null;
        try {
            newClassifier = (Classifier)ObjectCopyHelper.copyObject((Object)this.getClassifier());
            Evaluation evaluation = new Evaluation(newInstances);
            evaluation.crossValidateModel(newClassifier, newInstances, this.getFolds(), new Random(this.getCrossValidationSeed()), new Object[0]);
            double measure = 0.0;
            if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.ACC) {
                measure = evaluation.pctCorrect();
            } else if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.CC) {
                measure = evaluation.correlationCoefficient();
            } else if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.MAE) {
                measure = evaluation.meanAbsoluteError();
            } else if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.RAE) {
                measure = evaluation.relativeAbsoluteError();
            } else if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.RMSE) {
                measure = evaluation.rootMeanSquaredError();
            } else if (this.getMeasure() == AbstractWEKAFitnessFunction.Measure.RRSE) {
                measure = evaluation.rootRelativeSquaredError();
            } else {
                throw new IllegalStateException("Unhandled measure '" + (Object)((Object)this.getMeasure()) + "'!");
            }
            measure = this.getMeasure().adjust(measure);
            return measure;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error evaluating", (Throwable)e);
            return 0.0;
        }
    }

    public String getRemoveAsString(int[] m_weights) {
        String ret = "";
        int pos = 0;
        int last = -1;
        boolean thefirst = true;
        for (int a = 0; a < this.getInstances().numAttributes() - 1; ++a) {
            if (m_weights[a] == 0 && a != this.getInstances().classIndex()) {
                if (last == -1) continue;
                if (thefirst) {
                    thefirst = false;
                } else {
                    ret = String.valueOf(ret) + ",";
                }
                ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
                last = -1;
            }
            if (m_weights[a] == 0 && a != this.getInstances().classIndex()) continue;
            if (last == -1) {
                last = a;
            }
            pos = a;
        }
        if (last != -1) {
            if (!thefirst) {
                ret = String.valueOf(ret) + ",";
            }
            ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
        }
        return ret;
    }

    public void newBest(double val, OptData opd) {
        int cnt = 0;
        int[] weights = this.getWeights(opd);
        Instances newInstances = new Instances(this.getInstances());
        for (int i = 0; i < this.getInstances().numInstances(); ++i) {
            Instance in = newInstances.instance(i);
            cnt = 0;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (a == this.getInstances().classIndex()) continue;
                if (weights[cnt++] == 0) {
                    in.setValue(a, 0.0);
                    continue;
                }
                in.setValue(a, in.value(a));
            }
        }
        try {
            File file = new File(this.getOutputDirectory().getAbsolutePath() + File.separator + Double.toString(this.getMeasure().adjust(val)) + ".arff");
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Instances header = new Instances(newInstances, 0);
            Remove remove = new Remove();
            remove.setAttributeIndices(this.getRemoveAsString(weights));
            remove.setInvertSelection(true);
            header.setRelationName(OptionUtils.getCommandLine((Object)remove));
            writer.write(header.toString());
            writer.write("\n");
            for (int i = 0; i < newInstances.numInstances(); ++i) {
                writer.write(newInstances.instance(i).toString());
                writer.write("\n");
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

