/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.data.weka.WekaAttributeIndex;
import adams.flow.container.WekaTrainTestSetContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import weka.classifiers.AbstractSplitGenerator;
import weka.core.Instance;
import weka.core.Instances;

public class LeaveOneOutByValueGenerator
extends AbstractSplitGenerator {
    private static final long serialVersionUID = -6949071991599401776L;
    public static final String PLACEHOLDER_ORIGINAL = "@";
    public static final String PLACEHOLDER_TYPE = "$T";
    public static final String PLACEHOLDER_CURRENTVALUE = "$V";
    protected String m_RelationName;
    protected boolean m_Randomize;
    protected WekaAttributeIndex m_Index;
    protected transient List<String> m_UniqueValues;
    protected transient int m_CurrentPair;

    public LeaveOneOutByValueGenerator() {
    }

    public LeaveOneOutByValueGenerator(Instances data, long seed, boolean randomize, WekaAttributeIndex index) {
        this.setData(data);
        this.setSeed(seed);
        this.setRandomize(randomize);
        this.setIndex(index);
    }

    public String globalInfo() {
        return "Generates train/test split pairs using the unique values from the specified attribute. All values apart from one will be part of the training data and the remainder the test set. This is repeated for each unique value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("first"));
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
        this.m_OptionManager.add("relation-name", "relationName", (Object)PLACEHOLDER_ORIGINAL);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentPair = 1;
        this.m_UniqueValues = null;
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the attribute to determine the group from.";
    }

    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    public void setRelationName(String value) {
        this.m_RelationName = value;
        this.reset();
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public static String relationNameTipText() {
        return "The template for the relation name; available placeholders: @ for original, $T for type (train/test), $V for current value (string)";
    }

    @Override
    protected boolean canRandomize() {
        return this.m_Randomize;
    }

    @Override
    protected boolean checkNext() {
        return this.m_UniqueValues != null && this.m_CurrentPair <= this.m_UniqueValues.size();
    }

    @Override
    protected void doInitializeIterator() {
        if (this.m_Data == null) {
            throw new IllegalStateException("No data provided!");
        }
        if (this.canRandomize()) {
            this.m_Data = new Instances(this.m_Data);
            this.m_Data.randomize(new Random(this.getSeed()));
        }
        this.m_UniqueValues = new ArrayList<String>();
        this.m_Index.setData(this.m_Data);
        int col = this.m_Index.getIntIndex();
        if (col == -1) {
            throw new IllegalStateException("Attribute not found: " + this.m_Index.getIndex());
        }
        if (this.m_Data.attribute(col).isNumeric()) {
            throw new IllegalStateException("Attribute is numeric: " + this.m_Index.getIndex());
        }
        for (int i = 0; i < this.m_Data.attribute(col).numValues(); ++i) {
            this.m_UniqueValues.add(this.m_Data.attribute(col).value(i));
        }
        if (this.m_RelationName == null || this.m_RelationName.isEmpty()) {
            this.m_RelationName = PLACEHOLDER_ORIGINAL;
        }
    }

    protected String createRelationName(String relation, String template, String current, boolean train) {
        StringBuilder result = new StringBuilder();
        String name = template;
        while (name.length() > 0) {
            int len;
            if (name.startsWith(PLACEHOLDER_ORIGINAL)) {
                len = 1;
                result.append(relation);
            } else if (name.startsWith(PLACEHOLDER_TYPE)) {
                len = 2;
                if (train) {
                    result.append("train");
                } else {
                    result.append("test");
                }
            } else if (name.startsWith(PLACEHOLDER_CURRENTVALUE)) {
                len = 2;
                result.append(current);
            } else {
                len = 1;
                result.append(name.charAt(0));
            }
            name = name.substring(len);
        }
        return result.toString();
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        if (this.m_CurrentPair > this.m_UniqueValues.size()) {
            throw new NoSuchElementException("No more pairs available!");
        }
        this.m_Index.setData(this.m_Data);
        int col = this.m_Index.getIntIndex();
        String current = this.m_UniqueValues.get(this.m_CurrentPair - 1);
        Instances trainSet = new Instances(this.m_Data, this.m_Data.numInstances());
        Instances testSet = new Instances(this.m_Data, this.m_Data.numInstances());
        for (int i = 0; i < this.m_Data.numInstances(); ++i) {
            Instance inst = this.m_Data.instance(i);
            if (inst.stringValue(col).equals(current)) {
                testSet.add((Instance)inst.copy());
                continue;
            }
            trainSet.add((Instance)inst.copy());
        }
        trainSet.compactify();
        testSet.compactify();
        trainSet.setRelationName(this.createRelationName(this.m_Data.relationName(), this.m_RelationName, current, true));
        testSet.setRelationName(this.createRelationName(this.m_Data.relationName(), this.m_RelationName, current, false));
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet);
        ++this.m_CurrentPair;
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", relName=" + this.m_RelationName + ", index=" + (Object)((Object)this.m_Index);
    }
}

