/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.ThreadSafeClassifier;
import weka.classifiers.meta.AbstainMinimumProbability;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class AbstainingClassifierWrapper
extends SingleClassifierEnhancer
implements AbstainingClassifier,
ThreadSafeClassifier {
    private static final long serialVersionUID = 5699323936859571421L;
    public static final String TURN_OFF_ABSTAINING = "turn-off-abstaining";
    protected boolean m_TurnOffAbstaining = false;
    protected boolean m_CanAbstain = false;

    public AbstainingClassifierWrapper() {
        this.m_Classifier = new AbstainMinimumProbability();
    }

    protected String defaultClassifierString() {
        return AbstainMinimumProbability.class.getName();
    }

    public String globalInfo() {
        return "Wraps an abstaining classifier and allows turning on/of abstaining.";
    }

    public void setClassifier(Classifier value) {
        if (value instanceof AbstainingClassifier) {
            super.setClassifier(value);
        } else {
            System.err.println(this.getClass().getName() + ": an abstaining classifier is required, provided: " + value.getClass().getName());
        }
    }

    public void setTurnOffAbstaining(boolean value) {
        this.m_TurnOffAbstaining = value;
    }

    public boolean getTurnOffAbstaining() {
        return this.m_TurnOffAbstaining;
    }

    public String turnOffAbstainingTipText() {
        return "If enabled, abstaining of the base classifier is turned off.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.turnOffAbstainingTipText(), "false", TURN_OFF_ABSTAINING);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setTurnOffAbstaining(Utils.getFlag((String)TURN_OFF_ABSTAINING, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, TURN_OFF_ABSTAINING, this.getTurnOffAbstaining());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public synchronized void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        this.m_CanAbstain = this.m_Classifier instanceof AbstainingClassifier && ((AbstainingClassifier)this.m_Classifier).canAbstain();
    }

    public synchronized double classifyInstance(Instance instance) throws Exception {
        return super.classifyInstance(instance);
    }

    public synchronized double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_TurnOffAbstaining) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(instance);
        }
        return this.m_Classifier.distributionForInstance(instance);
    }

    @Override
    public boolean canAbstain() {
        return this.m_CanAbstain && !this.m_TurnOffAbstaining;
    }

    @Override
    public synchronized double getAbstentionClassification(Instance inst) throws Exception {
        if (this.canAbstain()) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return Utils.missingValue();
    }

    @Override
    public synchronized double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.canAbstain()) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n");
        result.append("\n");
        result.append("Abstaining turned off: " + this.m_TurnOffAbstaining + "\n");
        result.append("\n");
        result.append(this.m_Classifier.toString());
        return result.toString();
    }

    public static void main(String[] args) {
        AbstainingClassifierWrapper.runClassifier((Classifier)new AbstainingClassifierWrapper(), (String[])args);
    }
}

