/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.ObjectCopyHelper;
import adams.data.statistics.StatUtils;
import adams.env.Environment;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.multiprocess.WekaCrossValidationExecution;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class ClassifierCascade
extends RandomizableMultipleClassifiersCombiner {
    private static final long serialVersionUID = 8324353885319971960L;
    public static final String ATTRIBUTE_PREFIX = "Cascade-";
    public static final int DEFAULT_MAX_LEVELS = 10;
    public static final EvaluationStatistic DEFAULT_STATISTIC = EvaluationStatistic.PERCENT_CORRECT;
    public static final double DEFAULT_THRESHOLD = 90.0;
    public static final ThresholdCheck DEFAULT_THRESHOLD_CHECK = ThresholdCheck.ABOVE;
    public static final double DEFAULT_MIN_IMPROVEMENT = 0.01;
    public static final int DEFAULT_NUM_FOLDS = 10;
    public static final int DEFAULT_NUM_THREADS = -1;
    public static final double DEFAULT_HOLDOUT_PERCENTAGE = 20.0;
    public static final int DEFAULT_CLASS_INDEX = 0;
    public static final Combination DEFAULT_COMBINATION = Combination.MEDIAN;
    protected static String MAX_LEVELS = "max-levels";
    protected static String STATISTIC = "statistic";
    protected static String THRESHOLD = "threshold";
    protected static String THRESHOLD_CHECK = "threshold-check";
    protected static String MIN_IMPROVEMENT = "min-improvement";
    protected static String NUM_FOLDS = "num-folds";
    protected static String NUM_THREADS = "num-threads";
    protected static String HOLDOUT_PERCENTAGE = "holdout-percentage";
    protected static String CLASS_INDEX = "class-index";
    protected static String COMBINATION = "combination";
    protected int m_MaxLevels = 10;
    protected EvaluationStatistic m_Statistic = DEFAULT_STATISTIC;
    protected double m_Threshold = 90.0;
    protected ThresholdCheck m_ThresholdCheck = DEFAULT_THRESHOLD_CHECK;
    protected double m_MinImprovement = 0.01;
    protected int m_NumFolds = 10;
    protected int m_NumThreads = -1;
    protected double m_HoldOutPercentage = 20.0;
    protected int m_ClassIndex = 0;
    protected Combination m_Combination = DEFAULT_COMBINATION;
    protected List<List<Classifier>> m_Cascade = null;
    protected Instances m_MetaLevelHeader = null;
    protected List<Integer> m_MetaLevelStart = null;
    protected boolean m_Nominal;

    public String globalInfo() {
        return "Generates a classifier cascade, with each deeper level of classifiers being built on the input data and either the class distributions (nominal class) or classification (numeric class) of the classifiers of the previous level in the cascade.\nThe build process is stopped when either the maximum number of levels is reached, the termination criterion is satisfied or no further improvement is achieved.\nIn case of a level performing worse than the prior one, the build process is terminated immediately and the current level discarded.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.maxLevelsTipText(), "" + this.getMaxLevels(), MAX_LEVELS);
        WekaOptionUtils.addOption(result, this.statisticTipText(), "" + (Object)((Object)this.getStatistic()), STATISTIC);
        WekaOptionUtils.addOption(result, this.thresholdTipText(), "" + this.getThreshold(), THRESHOLD);
        WekaOptionUtils.addOption(result, this.thresholdCheckTipText(), "" + (Object)((Object)this.getThresholdCheck()), THRESHOLD_CHECK);
        WekaOptionUtils.addOption(result, this.minImprovementTipText(), "" + this.getMinImprovement(), MIN_IMPROVEMENT);
        WekaOptionUtils.addOption(result, this.numFoldsTipText(), "" + this.getNumFolds(), NUM_FOLDS);
        WekaOptionUtils.addOption(result, this.numThreadsTipText(), "" + this.getNumThreads(), NUM_THREADS);
        WekaOptionUtils.addOption(result, this.holdOutPercentageTipText(), "" + this.getHoldOutPercentage(), HOLDOUT_PERCENTAGE);
        WekaOptionUtils.addOption(result, this.classIndexTipText(), "" + this.getClassIndex(), CLASS_INDEX);
        WekaOptionUtils.addOption(result, this.combinationTipText(), "" + (Object)((Object)this.getCombination()), COMBINATION);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setMaxLevels(WekaOptionUtils.parse(options, MAX_LEVELS, 10));
        this.setStatistic((EvaluationStatistic)WekaOptionUtils.parse(options, STATISTIC, (Enum)DEFAULT_STATISTIC));
        this.setThreshold(WekaOptionUtils.parse(options, THRESHOLD, 90.0));
        this.setThresholdCheck((ThresholdCheck)WekaOptionUtils.parse(options, THRESHOLD_CHECK, (Enum)DEFAULT_THRESHOLD_CHECK));
        this.setMinImprovement(WekaOptionUtils.parse(options, MIN_IMPROVEMENT, 0.01));
        this.setNumFolds(WekaOptionUtils.parse(options, NUM_FOLDS, 10));
        this.setNumThreads(WekaOptionUtils.parse(options, NUM_THREADS, -1));
        this.setHoldOutPercentage(WekaOptionUtils.parse(options, HOLDOUT_PERCENTAGE, 20.0));
        this.setClassIndex(WekaOptionUtils.parse(options, CLASS_INDEX, 0));
        this.setCombination((Combination)WekaOptionUtils.parse(options, COMBINATION, (Enum)DEFAULT_COMBINATION));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, MAX_LEVELS, this.getMaxLevels());
        WekaOptionUtils.add(result, STATISTIC, (Enum)this.getStatistic());
        WekaOptionUtils.add(result, THRESHOLD, this.getThreshold());
        WekaOptionUtils.add(result, THRESHOLD_CHECK, (Enum)this.getThresholdCheck());
        WekaOptionUtils.add(result, MIN_IMPROVEMENT, this.getMinImprovement());
        WekaOptionUtils.add(result, NUM_FOLDS, this.getNumFolds());
        WekaOptionUtils.add(result, NUM_THREADS, this.getNumThreads());
        WekaOptionUtils.add(result, HOLDOUT_PERCENTAGE, this.getHoldOutPercentage());
        WekaOptionUtils.add(result, CLASS_INDEX, this.getClassIndex());
        WekaOptionUtils.add(result, COMBINATION, (Enum)this.getCombination());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public void setMaxLevels(int maxLevels) {
        this.m_MaxLevels = maxLevels;
    }

    public int getMaxLevels() {
        return this.m_MaxLevels;
    }

    public String maxLevelsTipText() {
        return "The maximum number of levels to build.";
    }

    public void setStatistic(EvaluationStatistic statistic) {
        this.m_Statistic = statistic;
    }

    public EvaluationStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to evaluate on.";
    }

    public void setThreshold(double threshold) {
        this.m_Threshold = threshold;
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold that, when reached, terminates the build process.";
    }

    public void setThresholdCheck(ThresholdCheck thresholdCheck) {
        this.m_ThresholdCheck = thresholdCheck;
    }

    public ThresholdCheck getThresholdCheck() {
        return this.m_ThresholdCheck;
    }

    public String thresholdCheckTipText() {
        return "How to apply the provided threshold.";
    }

    public void setMinImprovement(double minImprovement) {
        this.m_MinImprovement = minImprovement;
    }

    public double getMinImprovement() {
        return this.m_MinImprovement;
    }

    public String minImprovementTipText() {
        return "The minimum improvement between levels, otherwise the build process gets terminated.";
    }

    public void setNumFolds(int numFolds) {
        this.m_NumFolds = numFolds;
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds to use for internal cross-validation.";
    }

    public void setNumThreads(int numThreads) {
        this.m_NumThreads = numThreads;
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public String numThreadsTipText() {
        return "The number of threads to use.";
    }

    public void setHoldOutPercentage(double holdOutPercentage) {
        this.m_HoldOutPercentage = holdOutPercentage;
    }

    public double getHoldOutPercentage() {
        return this.m_HoldOutPercentage;
    }

    public String holdOutPercentageTipText() {
        return "The size of the validation set in percent (0-100).";
    }

    public void setClassIndex(int classIndex) {
        this.m_ClassIndex = classIndex;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The 0-based index of the class-label to use for class-label-based statistics.";
    }

    public void setCombination(Combination combination) {
        this.m_Combination = combination;
    }

    public Combination getCombination() {
        return this.m_Combination;
    }

    public String combinationTipText() {
        return "Determines how to combine the statistics.";
    }

    public Capabilities getCapabilities() {
        if (this.m_Classifiers.length == 0) {
            return new Capabilities((CapabilitiesHandler)this);
        }
        Capabilities result = this.m_Classifiers[0].getCapabilities();
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            Capabilities other = this.m_Classifiers[i].getCapabilities();
            result.and(other);
            if (other.getMinimumNumberInstances() <= result.getMinimumNumberInstances()) continue;
            result.setMinimumNumberInstances(other.getMinimumNumberInstances());
        }
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected Instances createMetaLevelHeader(Instances data) {
        int i;
        ArrayList<Integer> start = new ArrayList<Integer>();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        int classIndex = data.classIndex();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == classIndex) continue;
            atts.add((Attribute)data.attribute(i).copy());
        }
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            start.add(atts.size());
            if (data.classAttribute().isNominal()) {
                for (int n = 0; n < data.classAttribute().numValues(); ++n) {
                    atts.add(new Attribute(ATTRIBUTE_PREFIX + (i + 1) + "-" + (n + 1)));
                }
                continue;
            }
            atts.add(new Attribute(ATTRIBUTE_PREFIX + (i + 1)));
        }
        atts.add((Attribute)data.classAttribute().copy());
        Instances result = new Instances(ATTRIBUTE_PREFIX + data.relationName(), atts, 0);
        result.setClassIndex(result.numAttributes() - 1);
        if (this.m_MetaLevelStart == null) {
            this.m_MetaLevelStart = start;
        }
        return result;
    }

    protected Instance createMetaLevelInstance(Instances metaLevel, Instance data) {
        int i;
        int classIndex = data.classIndex();
        double[] values = new double[metaLevel.numAttributes()];
        int index = 0;
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == classIndex) continue;
            switch (data.attribute(i).type()) {
                case 0: 
                case 1: 
                case 3: {
                    values[index] = data.value(i);
                    break;
                }
                case 2: {
                    values[index] = metaLevel.attribute(index).addStringValue(data.stringValue(i));
                    break;
                }
                case 4: {
                    values[index] = metaLevel.attribute(index).addRelation(data.relationalValue(i));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type at #" + (i + 1) + ": " + Attribute.typeToString((int)data.attribute(i).type()));
                }
            }
            ++index;
        }
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (data.classAttribute().isNominal()) {
                for (int n = 0; n < data.classAttribute().numValues(); ++n) {
                    values[index] = Utils.missingValue();
                    ++index;
                }
                continue;
            }
            values[index] = Utils.missingValue();
            ++index;
        }
        values[values.length - 1] = data.classValue();
        DenseInstance result = new DenseInstance(data.weight(), values);
        result.setDataset(metaLevel);
        return result;
    }

    protected void addMetaLevelPrediction(Instance inst, int index, double[] dist) {
        for (int i = 0; i < dist.length; ++i) {
            if (Double.isNaN(dist[i])) {
                throw new IllegalStateException("NaN in class distribution of classifier " + (index + 1) + " at #" + (i + 1));
            }
            inst.setValue(this.m_MetaLevelStart.get(index) + i, dist[i]);
        }
    }

    protected void addMetaLevelPrediction(Instance inst, int index, double cls) {
        if (Double.isNaN(cls)) {
            throw new IllegalStateException("NaN in classification of classifier " + (index + 1) + "!");
        }
        inst.setValue(this.m_MetaLevelStart.get(index).intValue(), cls);
    }

    protected double applyCombination(double[] stats) {
        for (int i = 0; i < stats.length; ++i) {
            if (!Double.isNaN(stats[i])) continue;
            throw new IllegalStateException("NaN in statistics at #" + (i + 1) + "!");
        }
        switch (this.m_Combination) {
            case AVERAGE: {
                return StatUtils.mean((double[])stats);
            }
            case MEDIAN: {
                return StatUtils.median((double[])stats);
            }
        }
        throw new IllegalStateException("Unhandled combination: " + (Object)((Object)this.m_Combination));
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_MetaLevelHeader = null;
        DefaultRandomSplitGenerator rand = new DefaultRandomSplitGenerator(data, this.m_Seed, (100.0 - this.m_HoldOutPercentage) / 100.0);
        WekaTrainTestSetContainer cont = rand.next();
        Instances train = (Instances)cont.getValue("Train");
        Instances test = (Instances)cont.getValue("Test");
        Instances metaTrain = null;
        Instances metaTest = null;
        double stat = Double.NaN;
        this.m_Nominal = data.classAttribute().isNominal();
        this.m_Cascade = new ArrayList<List<Classifier>>();
        this.m_MetaLevelHeader = this.createMetaLevelHeader(train);
        for (int level = 0; level < this.m_MaxLevels; ++level) {
            boolean converged;
            int n;
            int i;
            this.m_Cascade.add(new ArrayList());
            if (this.getDebug()) {
                System.out.println("Level " + (level + 1) + "...");
            }
            double priorStat = stat;
            Instances priorTrain = metaTrain;
            Instances priorTest = metaTest;
            metaTrain = new Instances(this.m_MetaLevelHeader, train.numInstances());
            for (i = 0; i < this.m_Classifiers.length; ++i) {
                if (this.getDebug()) {
                    System.out.println("- Classifier " + (i + 1) + "...");
                }
                WekaCrossValidationExecution cv = new WekaCrossValidationExecution();
                cv.setClassifier((Classifier)ObjectCopyHelper.copyObject((Object)this.m_Classifiers[i]));
                cv.setNumThreads(this.m_NumThreads);
                cv.setDiscardPredictions(false);
                cv.setFolds(this.m_NumFolds);
                cv.setSeed(this.m_Seed);
                cv.setData(train);
                String msg = cv.execute();
                if (msg != null) {
                    throw new IllegalStateException("Failed to evaluate classifier #" + (i + 1) + " at level #" + (level + 1) + ":\n" + msg);
                }
                int[] indices = cv.getOriginalIndices();
                ArrayList preds = cv.getEvaluation().predictions();
                if (i == 0) {
                    HashMap<Integer, Instance> unordered = new HashMap<Integer, Instance>();
                    for (int index : indices) {
                        Instance inst = this.createMetaLevelInstance(metaTrain, train.instance(index));
                        unordered.put(index, inst);
                    }
                    for (n = 0; n < unordered.size(); ++n) {
                        metaTrain.add((Instance)unordered.get(n));
                    }
                    unordered.clear();
                }
                for (n = 0; n < indices.length; ++n) {
                    if (this.m_Nominal) {
                        this.addMetaLevelPrediction(metaTrain.instance(indices[n]), i, ((NominalPrediction)preds.get(n)).distribution());
                        continue;
                    }
                    this.addMetaLevelPrediction(metaTrain.instance(indices[n]), i, ((Prediction)preds.get(n)).predicted());
                }
            }
            ArrayList<Classifier> current = new ArrayList<Classifier>();
            for (i = 0; i < this.m_Classifiers.length; ++i) {
                Classifier cls = (Classifier)ObjectCopyHelper.copyObject((Object)this.m_Classifiers[i]);
                if (priorTrain == null) {
                    cls.buildClassifier(train);
                    current.add(cls);
                    continue;
                }
                cls.buildClassifier(metaTrain);
                current.add(cls);
            }
            this.m_Cascade.get(this.m_Cascade.size() - 1).addAll(current);
            double[] stats = new double[current.size()];
            for (i = 0; i < current.size(); ++i) {
                Evaluation eval;
                if (priorTest == null) {
                    eval = new Evaluation(test);
                    eval.evaluateModel((Classifier)current.get(i), test, new Object[0]);
                } else {
                    eval = new Evaluation(metaTest);
                    eval.evaluateModel((Classifier)current.get(i), metaTest, new Object[0]);
                }
                stats[i] = EvaluationHelper.getValue(eval, this.m_Statistic, this.m_ClassIndex);
            }
            if (this.getDebug()) {
                System.out.println("--> " + (Object)((Object)this.m_Statistic) + " (all): " + Utils.arrayToString((Object)stats));
            }
            stat = this.applyCombination(stats);
            if (this.getDebug()) {
                System.out.println("--> " + (Object)((Object)this.m_Statistic) + " (" + (Object)((Object)this.m_Combination) + "): " + stat);
            }
            switch (this.m_ThresholdCheck) {
                case ABOVE: {
                    converged = stat > this.m_Threshold;
                    break;
                }
                case BELOW: {
                    converged = stat < this.m_Threshold;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled threshold check (convergence): " + (Object)((Object)this.m_ThresholdCheck));
                }
            }
            if (this.getDebug()) {
                System.out.println("--> Converged: " + converged);
            }
            if (converged) break;
            if (!Double.isNaN(priorStat)) {
                boolean improved;
                switch (this.m_ThresholdCheck) {
                    case ABOVE: {
                        improved = stat >= priorStat + this.m_MinImprovement;
                        break;
                    }
                    case BELOW: {
                        improved = stat <= priorStat - this.m_MinImprovement;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled threshold check (improvement): " + (Object)((Object)this.m_ThresholdCheck));
                    }
                }
                if (this.getDebug()) {
                    System.out.println("--> Improved: " + improved);
                }
                if (!improved) {
                    this.m_Cascade.remove(this.m_Cascade.size() - 1);
                    break;
                }
            }
            metaTest = this.createMetaLevelHeader(test);
            for (n = 0; n < test.numInstances(); ++n) {
                metaTest.add(this.createMetaLevelInstance(metaTest, test.instance(n)));
            }
            if (priorTest == null) {
                priorTest = test;
            }
            for (i = 0; i < current.size(); ++i) {
                for (n = 0; n < metaTest.numInstances(); ++n) {
                    if (this.m_Nominal) {
                        this.addMetaLevelPrediction(metaTest.instance(n), i, ((Classifier)current.get(i)).distributionForInstance(priorTest.instance(n)));
                        continue;
                    }
                    this.addMetaLevelPrediction(metaTest.instance(n), i, ((Classifier)current.get(i)).classifyInstance(priorTest.instance(n)));
                }
            }
        }
    }

    protected Object predictionForInstance(Instance instance, boolean distribution) throws Exception {
        double[] dist;
        int i;
        ArrayList<Object> preds = new ArrayList<Object>();
        Instance meta = null;
        int finalLevel = this.m_Cascade.size() - 1;
        for (int level = 0; level < this.m_Cascade.size(); ++level) {
            double cls;
            List<Classifier> current = this.m_Cascade.get(level);
            Instance prior = meta;
            meta = this.createMetaLevelInstance(this.m_MetaLevelHeader, instance);
            if (level == 0) {
                for (i = 0; i < current.size(); ++i) {
                    if (distribution) {
                        dist = current.get(i).distributionForInstance(instance);
                        if (level == finalLevel) {
                            preds.add(dist);
                        }
                        this.addMetaLevelPrediction(meta, i, dist);
                        continue;
                    }
                    cls = current.get(i).classifyInstance(instance);
                    if (level == finalLevel) {
                        preds.add(cls);
                    }
                    this.addMetaLevelPrediction(meta, i, cls);
                }
                continue;
            }
            for (i = 0; i < current.size(); ++i) {
                if (distribution) {
                    dist = current.get(i).distributionForInstance(prior);
                    if (level == finalLevel) {
                        preds.add(dist);
                    }
                    this.addMetaLevelPrediction(meta, i, dist);
                    continue;
                }
                cls = current.get(i).classifyInstance(instance);
                if (level == finalLevel) {
                    preds.add(cls);
                }
                this.addMetaLevelPrediction(meta, i, cls);
            }
        }
        if (distribution) {
            dist = new double[instance.numClasses()];
            for (i = 0; i < dist.length; ++i) {
                double[] stats = new double[this.m_Classifiers.length];
                for (int n = 0; n < this.m_Classifiers.length; ++n) {
                    stats[n] = ((double[])preds.get(n))[i];
                }
                dist[i] = this.applyCombination(stats);
            }
            return dist;
        }
        double[] stats = new double[this.m_Classifiers.length];
        for (int n = 0; n < this.m_Classifiers.length; ++n) {
            stats[n] = (Double)preds.get(n);
        }
        return this.applyCombination(stats);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return (double[])this.predictionForInstance(instance, true);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return (Double)this.predictionForInstance(instance, false);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_Cascade == null) {
            result.append("No cascade built yet!");
        } else {
            result.append(((Object)((Object)this)).getClass().getName()).append("\n");
            result.append(((Object)((Object)this)).getClass().getName().replaceAll(".", "=")).append("\n\n");
            result.append("Max levels: ").append(this.m_MaxLevels).append("\n");
            result.append("Actual levels: ").append(this.m_Cascade.size()).append("\n");
            result.append("Statistic: ").append((Object)this.m_Statistic).append("\n");
            result.append("Threshold: ").append(this.m_Threshold).append("\n");
            result.append("Min improvement: ").append(this.m_MinImprovement).append("\n");
            result.append("# Folds: ").append(this.m_NumFolds).append("\n");
            result.append("Holdout %: ").append(this.m_HoldOutPercentage).append("\n");
            result.append("Classifiers:\n");
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                result.append(i + 1).append(". ").append(Utils.toCommandLine((Object)this.m_Classifiers[i])).append("\n");
            }
        }
        return result.toString();
    }

    public String getRevision() {
        return "$Revision: 12765 $";
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        ClassifierCascade.runClassifier((Classifier)new ClassifierCascade(), (String[])args);
    }

    public static enum ThresholdCheck {
        BELOW,
        ABOVE;

    }

    public static enum Combination {
        AVERAGE,
        MEDIAN;

    }
}

