/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import com.github.waikatodatamining.matrix.core.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.matrix.MatrixHelper;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.SupervisedFilter;

public class YGradientEPO
extends SimpleBatchFilter
implements SupervisedFilter {
    static final long serialVersionUID = -3335106965521265631L;
    protected double m_Alpha = this.getDefaultAlpha();
    protected int m_N = this.getDefaultN();
    protected com.github.waikatodatamining.matrix.algorithm.glsw.YGradientEPO m_Algorithm;

    public String globalInfo() {
        return "Applies the External Parameter Orthogonalization (EPO) algorithm to the data.\n\nFor more information see:\nhttp://wiki.eigenvector.com/index.php?title=Advanced_Preprocessing:_Multivariate_Filtering#External_Parameter_Orthogonalization_.28EPO.29";
    }

    public Enumeration<Option> listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.alphaTipText(), "" + this.getDefaultAlpha(), "alpha");
        WekaOptionUtils.addOption(result, this.NTipText(), "" + this.getDefaultN(), "N");
        WekaOptionUtils.add(result, super.listOptions());
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, "alpha", this.getAlpha());
        WekaOptionUtils.add(result, "N", this.getN());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        this.setAlpha(WekaOptionUtils.parse(options, "alpha", this.getDefaultAlpha()));
        this.setN(WekaOptionUtils.parse(options, "N", this.getDefaultN()));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected double getDefaultAlpha() {
        return 0.001;
    }

    public void setAlpha(double value) {
        if (value <= 0.0) {
            System.err.println("Alpha must be > 0 but was " + value + ".");
        } else {
            this.m_Alpha = value;
            this.reset();
        }
    }

    public double getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha parameter. Defines how strongly GLSW downweights interferences. Larger values (> 0.001) decreases the filtering effect. Smaller values (< 0.001) increase the filtering effect.";
    }

    protected int getDefaultN() {
        return 5;
    }

    public void setN(int value) {
        if (value <= 0) {
            System.err.println("Number of eigenvectors to keep must be > 0 but was " + value + ".");
        } else {
            this.m_N = value;
            this.reset();
        }
    }

    public int getN() {
        return this.m_N;
    }

    public String NTipText() {
        return "The number of eigenvectors to keep.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) continue;
            atts.add((Attribute)inputFormat.attribute(i).copy());
        }
        atts.add((Attribute)inputFormat.classAttribute().copy());
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(result.numAttributes() - 1);
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Matrix X = adams.data.instancesanalysis.pls.MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(instances));
        Matrix y = adams.data.instancesanalysis.pls.MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(instances));
        if (!this.isFirstBatchDone()) {
            this.m_Algorithm = new com.github.waikatodatamining.matrix.algorithm.glsw.YGradientEPO();
            this.m_Algorithm.setN(this.m_N);
            this.m_Algorithm.setAlpha(this.m_Alpha);
            String msg = this.m_Algorithm.initialize(X, y);
            if (msg != null) {
                throw new Exception(msg);
            }
        }
        Matrix X_new = this.m_Algorithm.transform(X);
        return adams.data.instancesanalysis.pls.MatrixHelper.toInstances(this.getOutputFormat(), adams.data.instancesanalysis.pls.MatrixHelper.matrixAlgoToWeka(X_new), adams.data.instancesanalysis.pls.MatrixHelper.matrixAlgoToWeka(y));
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10364 $");
    }

    public static void main(String[] args) {
        YGradientEPO.runFilter((Filter)new YGradientEPO(), (String[])args);
    }
}

