/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Index;
import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import adams.data.weka.WekaAttributeIndex;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;

public class NominalToNumeric
extends SimpleStreamFilter {
    private static final long serialVersionUID = -2908650889595166498L;
    public static final String INDEX = "index";
    public static final String TYPE = "type";
    public static final String FIND = "find";
    public static final String REPLACE = "replace";
    protected WekaAttributeIndex m_Index = this.getDefaultIndex();
    protected ConversionType m_Type = this.getDefaultType();
    protected BaseRegExp m_Find = this.getDefaultFind();
    protected String m_Replace = this.getDefaultReplace();
    protected int m_AttIndex;
    protected Map<String, Double> m_Mapping;

    public String globalInfo() {
        return "Converts a nominal attribute into a numeric one. Can either just use the internal representation of the labels as numeric value or parse the label itself (subset can be extracted via regexp).";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.indexTipText(), "" + (Object)((Object)this.getDefaultIndex()), INDEX);
        WekaOptionUtils.addOption(result, this.typeTipText(), "" + (Object)((Object)this.getDefaultType()), TYPE);
        WekaOptionUtils.addOption(result, this.findTipText(), "" + this.getDefaultFind(), FIND);
        WekaOptionUtils.addOption(result, this.replaceTipText(), "" + this.getDefaultReplace(), REPLACE);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setIndex((WekaAttributeIndex)WekaOptionUtils.parse(options, INDEX, (Index)this.getDefaultIndex()));
        this.setType((ConversionType)WekaOptionUtils.parse(options, TYPE, (Enum)this.getDefaultType()));
        this.setFind((BaseRegExp)WekaOptionUtils.parse(options, FIND, (BaseObject)this.getDefaultFind()));
        this.setReplace(WekaOptionUtils.parse(options, REPLACE, this.getDefaultReplace()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, INDEX, (Index)this.getIndex());
        WekaOptionUtils.add(result, TYPE, (Enum)this.getType());
        WekaOptionUtils.add(result, FIND, (BaseObject)this.getFind());
        WekaOptionUtils.add(result, REPLACE, this.getReplace());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected void reset() {
        super.reset();
        this.m_AttIndex = -1;
        this.m_Mapping = null;
    }

    protected WekaAttributeIndex getDefaultIndex() {
        return new WekaAttributeIndex("last");
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the attribute to convert; " + this.m_Index.getExample();
    }

    protected ConversionType getDefaultType() {
        return ConversionType.INTERNAL_REPRESENTATION;
    }

    public void setType(ConversionType value) {
        this.m_Type = value;
        this.reset();
    }

    public ConversionType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of conversion to perform.";
    }

    protected BaseRegExp getDefaultFind() {
        return new BaseRegExp(".*");
    }

    public void setFind(BaseRegExp value) {
        this.m_Find = value;
        this.reset();
    }

    public BaseRegExp getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The regular expression to use for extracting the numeric part from the label; use .* to match label as a whole.";
    }

    protected String getDefaultReplace() {
        return "$0";
    }

    public void setReplace(String value) {
        this.m_Replace = value;
        this.reset();
    }

    public String getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "The expression to use for assembling the numeric part; use $0 to use label as is.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        Attribute att;
        this.m_Index.setData(inputFormat);
        this.m_AttIndex = this.m_Index.getIntIndex();
        if (this.m_AttIndex == -1) {
            throw new Exception("Failed to locate attribute using index: " + (Object)((Object)this.m_Index));
        }
        if (!inputFormat.attribute(this.m_AttIndex).isNominal()) {
            throw new Exception("Attribute at '" + (Object)((Object)this.m_Index) + "' is not nominal!");
        }
        switch (this.m_Type) {
            case INTERNAL_REPRESENTATION: {
                break;
            }
            case FROM_LABEL: {
                this.m_Mapping = new HashMap<String, Double>();
                att = inputFormat.attribute(this.m_AttIndex);
                for (i = 0; i < att.numValues(); ++i) {
                    String value = att.value(i).replaceAll(this.m_Find.getValue(), this.m_Replace);
                    try {
                        this.m_Mapping.put(att.value(i), Double.parseDouble(value));
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to parse label #" + (i + 1) + " '" + att.value(i) + "' with " + this.m_Find + "/" + this.m_Replace + " -> " + value + "!", e);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled conversion type: " + (Object)((Object)this.m_Type));
            }
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            att = inputFormat.attribute(i);
            if (i == this.m_AttIndex) {
                atts.add(new Attribute(att.name()));
                continue;
            }
            atts.add((Attribute)att.copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        double[] values = instance.toDoubleArray();
        switch (this.m_Type) {
            case INTERNAL_REPRESENTATION: {
                break;
            }
            case FROM_LABEL: {
                if (Utils.isMissingValue((double)values[this.m_AttIndex])) break;
                values[this.m_AttIndex] = this.m_Mapping.get(instance.stringValue(this.m_AttIndex));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled conversion type: " + (Object)((Object)this.m_Type));
            }
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.outputFormatPeek());
        this.copyValues((Instance)result, false, instance.dataset(), this.outputFormatPeek());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        NominalToNumeric.runFilter((Filter)new NominalToNumeric(), (String[])args);
    }

    public static enum ConversionType {
        INTERNAL_REPRESENTATION,
        FROM_LABEL;

    }
}

