/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.utils.SavitzkyGolay;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class SavitzkyGolay2
extends SimpleStreamFilter
implements TechnicalInformationHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = 6860559375223030676L;
    protected int m_PolynomialOrder = 2;
    protected int m_DerivativeOrder = 1;
    protected int m_NumPoints = 3;
    protected boolean m_KeepAttributeNames;
    protected double[] m_Coefficients;

    public String globalInfo() {
        return "A filter that applies Savitzky-Golay smoothing.\nIf a class attribute is present this will not be touched and moved to the end.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Savitzky and Marcel J.E. Golay");
        result.setValue(TechnicalInformation.Field.TITLE, "Smoothing and Differentiation of Data by Simplified Least Squares Procedures");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Analytical Chemistry");
        result.setValue(TechnicalInformation.Field.VOLUME, "36");
        result.setValue(TechnicalInformation.Field.PAGES, "1627-1639");
        result.setValue(TechnicalInformation.Field.YEAR, "1964");
        result.setValue(TechnicalInformation.Field.HTTP, "http://dx.doi.org/10.1021/ac60214a047");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INBOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "William H. Press and Saul A. Teukolsky and William T. Vetterling and Brian P. Flannery");
        additional.setValue(TechnicalInformation.Field.SERIES, "Numerical Recipes in C");
        additional.setValue(TechnicalInformation.Field.EDITION, "Second");
        additional.setValue(TechnicalInformation.Field.TITLE, "Savitzky-Golay Smoothing Filters");
        additional.setValue(TechnicalInformation.Field.CHAPTER, "14.8");
        additional.setValue(TechnicalInformation.Field.PAGES, "650-655");
        additional.setValue(TechnicalInformation.Field.YEAR, "1992");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Cambridge University Press");
        additional.setValue(TechnicalInformation.Field.PDF, "http://www.nrbook.com/a/bookcpdf/c14-8.pdf");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe number of points to the left (>= 0).\n\t(default: 3)", "left", 1, "-left <int>"));
        result.addElement(new Option("\tThe number of points to the right (>= 0).\n\t(default: 3)", "right", 1, "-right <int>"));
        result.addElement(new Option("\tThe polynomial order (>= 2).\n\t(default: 2)", "polynomial", 1, "-polynomial <int>"));
        result.addElement(new Option("\tThe order of the derivative (>= 0).\n\t(default: 1)", "derivative", 1, "-derivative <int>"));
        result.addElement(new Option("\tWhether to keep the original attribute names or use new ones ('att-XYZ').\n\t(default: don't keep)", "keep-attribute-names", 0, "-keep-attribute-names"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"points", (String[])options);
        if (tmpStr.length() > 0) {
            this.setNumPoints(Integer.parseInt(tmpStr));
        } else {
            this.setNumPoints(3);
        }
        tmpStr = Utils.getOption((String)"polynomial", (String[])options);
        if (tmpStr.length() > 0) {
            this.setPolynomialOrder(Integer.parseInt(tmpStr));
        } else {
            this.setPolynomialOrder(2);
        }
        tmpStr = Utils.getOption((String)"derivative", (String[])options);
        if (tmpStr.length() > 0) {
            this.setDerivativeOrder(Integer.parseInt(tmpStr));
        } else {
            this.setDerivativeOrder(1);
        }
        this.setKeepAttributeNames(Utils.getFlag((String)"keep-attribute-names", (String[])options));
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-points");
        result.add("" + this.getNumPoints());
        result.add("-polynomial");
        result.add("" + this.getPolynomialOrder());
        result.add("-derivative");
        result.add("" + this.getDerivativeOrder());
        if (this.getKeepAttributeNames()) {
            result.add("-keep-attribute-names");
        }
        return result.toArray(new String[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Coefficients = null;
    }

    public void setPolynomialOrder(int value) {
        if (value >= 2) {
            this.m_PolynomialOrder = value;
            this.reset();
        } else {
            System.err.println("The polynomial order must be at least 2 (provided: " + value + ")!");
        }
    }

    public int getPolynomialOrder() {
        return this.m_PolynomialOrder;
    }

    public String polynomialOrderTipText() {
        return "The polynomial order to use, must be at least 2.";
    }

    public void setDerivativeOrder(int value) {
        if (value >= 0) {
            this.m_DerivativeOrder = value;
            this.reset();
        } else {
            System.err.println("The order of the derivative must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getDerivativeOrder() {
        return this.m_DerivativeOrder;
    }

    public String derivativeOrderTipText() {
        return "The order of the derivative to use, >= 0.";
    }

    public void setNumPoints(int value) {
        if (value >= 0) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            System.err.println("The number of points to the left must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points left of a data point, >= 0.";
    }

    public void setKeepAttributeNames(boolean value) {
        this.m_KeepAttributeNames = value;
        this.reset();
    }

    public boolean getKeepAttributeNames() {
        return this.m_KeepAttributeNames;
    }

    public String keepAttributeNamesTipText() {
        return "If enabled, the original attribute names are kept rather than using new ones ('att-XYZ').";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        boolean hasClass = inputFormat.classIndex() > -1;
        int count = inputFormat.numAttributes();
        if (hasClass) {
            --count;
        }
        count -= this.m_NumPoints + this.m_NumPoints + 1;
        ArrayList<String> original = new ArrayList<String>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) continue;
            original.add(inputFormat.attribute(i).name());
        }
        for (i = 0; i < this.m_NumPoints; ++i) {
            original.remove(0);
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < count; ++i) {
            if (this.m_KeepAttributeNames) {
                atts.add(new Attribute((String)original.get(i)));
                continue;
            }
            atts.add(new Attribute("att" + (i + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        int i;
        if (this.m_Coefficients == null) {
            this.m_Coefficients = SavitzkyGolay.determineCoefficients((int)this.m_NumPoints, (int)this.m_NumPoints, (int)this.m_PolynomialOrder, (int)this.m_DerivativeOrder);
        }
        boolean hasClass = instance.classIndex() > -1;
        int count = instance.numAttributes();
        if (hasClass) {
            --count;
        }
        double[] valuesOld = new double[count];
        int n = 0;
        for (i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            valuesOld[n] = instance.value(i);
            ++n;
        }
        int width = this.m_NumPoints + this.m_NumPoints + 1;
        double[] values = new double[count - width + 1];
        for (i = 0; i <= count - width; ++i) {
            values[i] = 0.0;
            for (n = 0; n < width; ++n) {
                int n2 = i;
                values[n2] = values[n2] + this.m_Coefficients[n] * valuesOld[i + n];
            }
        }
        if (hasClass) {
            values[values.length - 1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        SavitzkyGolay2.runFilter((Filter)new SavitzkyGolay2(), (String[])args);
    }
}

