/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.data.statistics.StatCalc;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class RowNorm
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 6812351429964183179L;

    public String globalInfo() {
        return "Row wise normalization.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instance process(Instance instance) throws Exception {
        int i;
        double[] values = instance.toDoubleArray();
        StatCalc sc = new StatCalc();
        for (i = 0; i < values.length; ++i) {
            if (i == instance.classIndex()) continue;
            sc.enter(values[i]);
        }
        double mn = sc.getMean();
        double sd = sc.getStandardDeviation();
        Instance result = (Instance)instance.copy();
        for (i = 0; i < values.length; ++i) {
            if (i == instance.classIndex()) continue;
            result.setValue(i, (values[i] - mn) / sd);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        RowNorm.runFilter((Filter)new RowNorm(), (String[])args);
    }
}

