/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.instance.RemoveRange;

public class SafeRemoveRange
extends SimpleBatchFilter
implements UnsupervisedFilter {
    static final long serialVersionUID = -3064641215340828695L;
    protected Range m_Range = new Range("first-last");
    protected boolean m_InvertSelection;

    public String globalInfo() {
        return "A filter that removes a given range of instances of a dataset.\nWorks just like " + RemoveRange.class.getName() + ", but has a more robust handling of instance ranges. E.g., removal of 30-100 will not result in an error when presenting only 20 or 40 instances, but return no instance or instances 30-40 instead.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecifies list of instances to select. First and last\n\tare valid indexes. (default: first-last)\n", "R", 1, "-R <inst1,inst2-inst4,...>"));
        result.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'R', (String[])options);
        if (tmpStr.length() != 0) {
            this.setInstancesIndices(tmpStr);
        } else {
            this.setInstancesIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag((char)'V', (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add(this.getInstancesIndices());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setInstancesIndices(String value) {
        this.m_Range.setRange(value);
    }

    public String getInstancesIndices() {
        return this.m_Range.getRange();
    }

    public String instancesIndicesTipText() {
        return "The range of instances to select; " + this.m_Range.getExample();
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result;
        if (!this.isFirstBatchDone()) {
            Range range = new Range(this.m_Range.getRange());
            range.setInverted(this.m_InvertSelection);
            range.setMax(instances.numInstances());
            result = new Instances(this.getOutputFormat(), instances.size());
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (range.isInRange(i)) continue;
                result.add(instances.instance(i));
                this.copyValues(instances.instance(i), true, instances, result);
            }
            result.compactify();
        } else {
            result = instances;
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        SafeRemoveRange.runFilter((Filter)new SafeRemoveRange(), (String[])args);
    }
}

