/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class WeightsBasedResample
extends SimpleBatchFilter
implements UnsupervisedFilter,
Randomizable {
    private static final long serialVersionUID = -6784901276150528252L;
    protected double m_DropBelow = 0.0;
    protected double m_DropAtMost = 1.0;
    protected double m_MaxFactor = -1.0;
    protected double m_SizeLimit = -1.0;
    protected int m_Seed = 1;

    public String globalInfo() {
        return "Normalizes all instance weights and drops the ones that fall below the specified threshold, but at most the specified percentage.\nOf the left over instances, the smallest weight, e.g., 0.2, represents one instance, which translates a weight of 1.0 to five instances. This factor can be limited to avoid an instance explosion if the smallest weight is very small.\nThe overall, final dataset size can be limited as well.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe threshold for the (normalized) weight below which instances\n\tget dropped.\n\tdefault: 0.0", "drop-below", 1, "-drop-below <0.0-1.0>"));
        result.addElement(new Option("\tThe maximum percentage of instances to drop (0-1).\n\tdefault: 1.0", "drop-at-most", 1, "-drop-at most <0.0-1.0>"));
        result.addElement(new Option("\tThe maximum factor to allow for instances to be multiplied with.\n\tDisabled if <= 0.\n\tdefault: -1", "max-factor", 1, "-max-factor <num>"));
        result.addElement(new Option("\tThe size limit for the resulting dataset.\n\tDisabled if <= 0, percentage if 0<x<=10 (0-10,000%), \n\t>10 absolute number of instances.\n\tdefault: -1", "size-limit", 1, "-size-limit <num>"));
        result.addElement(new Option("\tThe seed value for randomizing the final dataset.\n\tdefault: 1", "seed", 1, "-seed <num>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"drop-below", (String[])options);
        if (tmpStr.length() == 0) {
            this.setDropBelow(0.0);
        } else {
            this.setDropBelow(Double.parseDouble(tmpStr));
        }
        tmpStr = Utils.getOption((String)"drop-at-most", (String[])options);
        if (tmpStr.length() == 0) {
            this.setDropAtMost(1.0);
        } else {
            this.setDropAtMost(Double.parseDouble(tmpStr));
        }
        tmpStr = Utils.getOption((String)"max-factor", (String[])options);
        if (tmpStr.length() == 0) {
            this.setMaxFactor(-1.0);
        } else {
            this.setMaxFactor(Double.parseDouble(tmpStr));
        }
        tmpStr = Utils.getOption((String)"size-limit", (String[])options);
        if (tmpStr.length() == 0) {
            this.setSizeLimit(-1.0);
        } else {
            this.setSizeLimit(Double.parseDouble(tmpStr));
        }
        tmpStr = Utils.getOption((String)"seed", (String[])options);
        if (tmpStr.length() == 0) {
            this.setSeed(1);
        } else {
            this.setSeed(Integer.parseInt(tmpStr));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-drop-below");
        result.add("" + this.getDropBelow());
        result.add("-drop-at-most");
        result.add("" + this.getDropAtMost());
        result.add("-max-factor");
        result.add("" + this.getMaxFactor());
        result.add("-size-limit");
        result.add("" + this.getSizeLimit());
        result.add("-seed");
        result.add("" + this.getSeed());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[0]);
    }

    public void setDropBelow(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_DropBelow = value;
        } else {
            System.err.println("'drop-below' threshold must be within [0;1], provided: " + value);
        }
    }

    public double getDropBelow() {
        return this.m_DropBelow;
    }

    public String dropBelowTipText() {
        return "The threshold of the normalized weights below which to drop instances (0-1).";
    }

    public void setDropAtMost(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_DropAtMost = value;
        } else {
            System.err.println("'drop-at-most' must be within [0;1], provided: " + value);
        }
    }

    public double getDropAtMost() {
        return this.m_DropAtMost;
    }

    public String dropAtMostTipText() {
        return "The maximum percentage of instances to drop (0-1).";
    }

    public void setMaxFactor(double value) {
        this.m_MaxFactor = value;
    }

    public double getMaxFactor() {
        return this.m_MaxFactor;
    }

    public String maxFactorTipText() {
        return "The upper limit for the multiplication factor for instances, disabled if <= 0.";
    }

    public void setSizeLimit(double value) {
        this.m_SizeLimit = value;
    }

    public double getSizeLimit() {
        return this.m_SizeLimit;
    }

    public String sizeLimitTipText() {
        return "The size limit for the final dataset: disabled if <= 0, 0<x<=10 percentage (0-10,000%), >10 absolute number of instances.";
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value to use for randomizing the final dataset.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        if (this.m_FirstBatchDone) {
            return new Instances(instances);
        }
        final double[] weights = new double[instances.numInstances()];
        for (i = 0; i < instances.numInstances(); ++i) {
            weights[i] = instances.instance(i).weight();
        }
        double min = weights[Utils.minIndex((double[])weights)];
        double max = weights[Utils.maxIndex((double[])weights)];
        double range = max - min;
        if (this.getDebug()) {
            System.err.println("min weight: " + min + ", max weight: " + max + ", range: " + range);
        }
        if (range == 0.0) {
            System.err.println("No difference between smallest and largest weight, cannot resample!");
            return new Instances(instances);
        }
        for (i = 0; i < weights.length; ++i) {
            weights[i] = (weights[i] - min) / range;
        }
        double dropBelow = this.m_DropBelow;
        TDoubleArrayList dropped = new TDoubleArrayList();
        for (i = 0; i < weights.length; ++i) {
            if (!(weights[i] < this.m_DropBelow)) continue;
            dropped.add(weights[i]);
        }
        if ((double)dropped.size() / (double)instances.numInstances() > this.m_DropAtMost) {
            dropped.sort();
            int index = dropped.size() - (int)Math.round((double)instances.numInstances() * this.m_DropAtMost) + 1;
            dropBelow = dropped.get(index);
        }
        if (this.getDebug()) {
            System.err.println("Drop below (defined/used): " + this.m_DropBelow + "/" + dropBelow);
        }
        ArrayList<Integer> cleaned = new ArrayList<Integer>();
        for (i = 0; i < instances.numInstances(); ++i) {
            if (!(weights[i] > dropBelow)) continue;
            cleaned.add(i);
        }
        Collections.sort(cleaned, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(weights[o1], weights[o2]);
            }
        });
        int maxSize = -1;
        if (this.m_SizeLimit > 0.0) {
            maxSize = this.m_SizeLimit <= 10.0 ? (int)Math.round((double)instances.numInstances() * (this.m_SizeLimit * 100.0)) : (int)this.m_SizeLimit;
        }
        if (this.getDebug()) {
            System.err.println("Max dataset size: " + maxSize);
        }
        Instances result = new Instances(instances, maxSize);
        for (i = 0; i < cleaned.size(); ++i) {
            double factor = 1.0 / weights[(Integer)cleaned.get(i)];
            if (this.m_MaxFactor > 0.0) {
                factor = Math.max(this.m_MaxFactor, factor);
            }
            if ((factor = (double)((int)Math.round(factor))) < 1.0) {
                factor = 1.0;
            }
            int n = 0;
            while ((double)n < factor) {
                result.add((Instance)instances.get(((Integer)cleaned.get(n)).intValue()).copy());
                result.get(result.size() - 1).setWeight(1.0);
                ++n;
            }
            if (maxSize > -1 && result.numInstances() >= maxSize) break;
        }
        result.compactify();
        if (this.getDebug()) {
            System.err.println("Final dataset size: " + result.numInstances());
        }
        result.randomize(new Random(this.m_Seed));
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        WeightsBasedResample.runFilter((Filter)new WeightsBasedResample(), (String[])args);
    }
}

