/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import adams.core.ObjectCopyHelper;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingHelper;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextField;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Range;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.Loader;
import weka.core.converters.XRFFLoader;
import weka.core.converters.XRFFSaver;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.InstancesResultListener;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.ResultListener;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;

public class ExperimentPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 2078066653508312179L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel((PropertyEditor)this.m_ClassifierEditor);
    protected BaseTextArea m_OutText = new BaseTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, (Component)this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel((JTextComponent)this.m_OutText);
    protected JSpinner m_RunsSpinner = new JSpinner();
    protected BaseComboBox m_EvalCombo = new BaseComboBox((Object[])new String[]{"Cross-validation", "Random split"});
    protected JLabel m_FoldsPercLabel = new JLabel("Folds");
    protected BaseTextField m_FoldsPercText = new BaseTextField("10", 10);
    protected BaseComboBox m_ClassCombo = new BaseComboBox();
    protected BaseButton m_StartBut = new BaseButton("Start");
    protected BaseButton m_StopBut = new BaseButton("Stop");
    private Dimension COMBO_SIZE;
    protected Instances m_Instances;
    protected Loader m_TestLoader;
    protected Thread m_RunThread;

    public ExperimentPanel() {
        this.COMBO_SIZE = new Dimension(100, this.m_StartBut.getPreferredSize().height);
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(Fonts.getMonospacedFont());
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    ExperimentPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder((Border)BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_ClassifierEditor.setClassType(Classifier.class);
        this.m_ClassifierEditor.setValue(ExplorerDefaults.getClassifier());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ExperimentPanel.this.repaint();
            }
        });
        this.m_RunsSpinner.setToolTipText("The number of runs to perform");
        this.m_RunsSpinner.setEnabled(false);
        ((SpinnerNumberModel)this.m_RunsSpinner.getModel()).setMinimum(new Integer(1));
        ((SpinnerNumberModel)this.m_RunsSpinner.getModel()).setValue(new Integer(10));
        this.m_EvalCombo.setToolTipText("The type of evaluation to be performed");
        this.m_EvalCombo.setEnabled(false);
        this.m_EvalCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_EvalCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_EvalCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_EvalCombo.setSelectedIndex(0);
        this.m_EvalCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = ExperimentPanel.this.m_EvalCombo.getSelectedIndex();
                if (selected == 0) {
                    ExperimentPanel.this.m_FoldsPercLabel.setText("Folds");
                    ExperimentPanel.this.m_FoldsPercText.setText("10");
                } else if (selected == 1) {
                    ExperimentPanel.this.m_FoldsPercLabel.setText("Percentage");
                    ExperimentPanel.this.m_FoldsPercText.setText("66");
                }
            }
        });
        this.m_FoldsPercText.setToolTipText("Folds for cross-validation, percentage for random split");
        this.m_FoldsPercText.setEnabled(false);
        this.m_ClassCombo.setToolTipText("Select the attribute to use as the class");
        this.m_ClassCombo.setEnabled(false);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentPanel.this.updateCapabilitiesFilter(ExperimentPanel.this.m_ClassifierEditor.getCapabilitiesFilter());
            }
        });
        this.m_StartBut.setToolTipText("Starts the experiment");
        this.m_StartBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentPanel.this.startExperiment();
            }
        });
        this.m_StopBut.setToolTipText("Stops a running experiment");
        this.m_StopBut.setEnabled(false);
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentPanel.this.stopExperiment();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = ExperimentPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = ExperimentPanel.this.m_History.getNameAtIndex(index);
                        ExperimentPanel.this.showPopup(name, e.getX(), e.getY());
                    } else {
                        ExperimentPanel.this.showPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Classifier"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CEPanel, "North");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Experiment options"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 5, 2, 5);
        JLabel label = new JLabel("Runs");
        gbL.setConstraints(label, gbC);
        p2.add(label);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints(this.m_RunsSpinner, gbC);
        p2.add(this.m_RunsSpinner);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 5, 2, 5);
        label = new JLabel("Evaluation");
        gbL.setConstraints(label, gbC);
        p2.add(label);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints((Component)this.m_EvalCombo, gbC);
        p2.add((Component)this.m_EvalCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints(this.m_FoldsPercLabel, gbC);
        p2.add(this.m_FoldsPercLabel);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints((Component)this.m_FoldsPercText, gbC);
        p2.add((Component)this.m_FoldsPercText);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 2));
        buttons.add((Component)this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add((Component)this.m_StartBut);
        ssButs.add((Component)this.m_StopBut);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Experiment output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane((Component)this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints((Component)this.m_History, gbC);
        mondo.add((Component)this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    type = "(Nom) ";
                    break;
                }
                case 0: {
                    type = "(Num) ";
                    break;
                }
                case 2: {
                    type = "(Str) ";
                    break;
                }
                case 3: {
                    type = "(Dat) ";
                    break;
                }
                case 4: {
                    type = "(Rel) ";
                    break;
                }
                default: {
                    type = "(???) ";
                }
            }
            attribNames[i] = type + this.m_Instances.attribute(i).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (attribNames.length > 0) {
            if (inst.classIndex() == -1) {
                this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
            } else {
                this.m_ClassCombo.setSelectedIndex(inst.classIndex());
            }
            this.m_ClassCombo.setEnabled(true);
            this.m_EvalCombo.setEnabled(true);
            this.m_RunsSpinner.setEnabled(true);
            this.m_FoldsPercText.setEnabled(true);
            this.m_StartBut.setEnabled(this.m_RunThread == null);
            this.m_StopBut.setEnabled(this.m_RunThread != null);
        } else {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(false);
        }
    }

    protected void showPopup(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem viewMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            viewMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimentPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            viewMainBuffer.setEnabled(false);
        }
        resultListMenu.add(viewMainBuffer);
        JMenuItem viewSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            viewSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimentPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            viewSepBuffer.setEnabled(false);
        }
        resultListMenu.add(viewSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimentPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimentPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startExperiment() {
        if (this.m_RunThread == null) {
            ExperimentPanel experimentPanel = this;
            synchronized (experimentPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PropertyNode[] propertyPath;
                    ExperimentPanel.this.m_Log.statusMessage("Setting up...");
                    Instances inst = new Instances(ExperimentPanel.this.m_Instances);
                    int classIndex = ExperimentPanel.this.m_ClassCombo.getSelectedIndex();
                    inst.setClassIndex(classIndex);
                    File tmpDataset = null;
                    try {
                        tmpDataset = TempUtils.createTempFile((String)"weka_", (String)XRFFLoader.FILE_EXTENSION_COMPRESSED);
                        tmpDataset.deleteOnExit();
                        XRFFSaver saver = new XRFFSaver();
                        saver.setFile(tmpDataset);
                        saver.setInstances(inst);
                        saver.writeBatch();
                    }
                    catch (Exception ex) {
                        ExperimentPanel.this.m_Log.logMessage("Problem saving instances to tmp. file: " + ex.getMessage());
                    }
                    Experiment exp = new Experiment();
                    exp.setPropertyArray((Object)new Classifier[0]);
                    exp.setUsePropertyIterator(true);
                    ClassifierSplitEvaluator se = null;
                    Classifier sec = null;
                    if (inst.classAttribute().isNominal()) {
                        se = new ClassifierSplitEvaluator();
                        sec = se.getClassifier();
                    } else if (inst.classAttribute().isNumeric()) {
                        se = new RegressionSplitEvaluator();
                        sec = ((RegressionSplitEvaluator)se).getClassifier();
                    } else {
                        throw new IllegalArgumentException("Unknown evaluation type!");
                    }
                    if (ExperimentPanel.this.m_EvalCombo.getSelectedIndex() == 0) {
                        CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
                        cvrp.setNumFolds(Integer.parseInt(ExperimentPanel.this.m_FoldsPercText.getText()));
                        cvrp.setSplitEvaluator((SplitEvaluator)se);
                        propertyPath = new PropertyNode[2];
                        try {
                            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
                            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                        }
                        catch (IntrospectionException e) {
                            e.printStackTrace();
                        }
                        exp.setResultProducer((ResultProducer)cvrp);
                        exp.setPropertyPath(propertyPath);
                    } else if (ExperimentPanel.this.m_EvalCombo.getSelectedIndex() == 1) {
                        RandomSplitResultProducer rsrp = new RandomSplitResultProducer();
                        rsrp.setRandomizeData(true);
                        rsrp.setTrainPercent(Double.parseDouble(ExperimentPanel.this.m_FoldsPercText.getText()));
                        rsrp.setSplitEvaluator((SplitEvaluator)se);
                        propertyPath = new PropertyNode[2];
                        try {
                            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", RandomSplitResultProducer.class), RandomSplitResultProducer.class);
                            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
                        }
                        catch (IntrospectionException e) {
                            e.printStackTrace();
                        }
                        exp.setResultProducer((ResultProducer)rsrp);
                        exp.setPropertyPath(propertyPath);
                    } else {
                        throw new IllegalArgumentException("Unknown evaluation type!");
                    }
                    exp.setRunLower(1);
                    exp.setRunUpper(((Integer)ExperimentPanel.this.m_RunsSpinner.getValue()).intValue());
                    try {
                        exp.setPropertyArray((Object)new Classifier[]{(Classifier)ObjectCopyHelper.copyObject((Object)ExperimentPanel.this.m_ClassifierEditor.getValue())});
                    }
                    catch (Exception ex) {
                        ExperimentPanel.this.m_Log.logMessage("Problem creating copy of classifier: " + ex.getMessage());
                    }
                    DefaultListModel<File> model = new DefaultListModel<File>();
                    model.addElement(tmpDataset);
                    exp.setDatasets(model);
                    InstancesResultListener irl = new InstancesResultListener();
                    File tmpResult = null;
                    try {
                        tmpResult = TempUtils.createTempFile((String)"weka_result_", (String)ArffLoader.FILE_EXTENSION);
                        tmpResult.deleteOnExit();
                    }
                    catch (Exception ex) {
                        ExperimentPanel.this.m_Log.logMessage("Problem creating tmp file for experiment result: " + ex.getMessage());
                    }
                    irl.setOutputFile(tmpResult);
                    exp.setResultListener((ResultListener)irl);
                    try {
                        int n;
                        String[] values;
                        ExperimentPanel.this.m_Log.logMessage("Started experiment for " + ExperimentPanel.this.m_ClassifierEditor.getValue().getClass().getName());
                        if (ExperimentPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)ExperimentPanel.this.m_Log).taskStarted();
                        }
                        ExperimentPanel.this.m_Log.statusMessage("Experiment started...");
                        exp.initialize();
                        exp.runExperiment();
                        exp.postProcess();
                        ExperimentPanel.this.m_Log.statusMessage("Evaluating experiment...");
                        Object result = new Instances((Reader)new BufferedReader(new FileReader(irl.getOutputFile())));
                        PairedCorrectedTTester tester = new PairedCorrectedTTester();
                        tester.setInstances(result);
                        tester.setSortColumn(-1);
                        tester.setRunColumn(result.attribute("Key_Run").index());
                        if (inst.classAttribute().isNominal()) {
                            tester.setFoldColumn(result.attribute("Key_Fold").index());
                        }
                        tester.setResultsetKeyColumns(new Range("" + (result.attribute("Key_Dataset").index() + 1)));
                        tester.setDatasetKeyColumns(new Range("" + (result.attribute("Key_Scheme").index() + 1) + "," + (result.attribute("Key_Scheme_options").index() + 1) + "," + (result.attribute("Key_Scheme_version_ID").index() + 1)));
                        tester.setResultMatrix((ResultMatrix)new ResultMatrixPlainText());
                        tester.setDisplayedResultsets(null);
                        tester.setSignificanceLevel(0.05);
                        tester.setShowStdDevs(true);
                        int startIndex = result.attribute("Date_time").index() + 1;
                        int decimals = 4;
                        int width = 12;
                        int[] widths = new int[3];
                        Vector<String[]> list = new Vector<String[]>();
                        list.add(new String[]{"Measure", "Mean", "StdDev"});
                        list.add(new String[]{"=======", "====", "======"});
                        for (int i = startIndex; i < result.numAttributes(); ++i) {
                            if (!result.attribute(i).isNumeric()) continue;
                            values = new String[3];
                            list.add(values);
                            tester.multiResultsetFull(0, i);
                            ResultMatrix matrix = tester.getResultMatrix();
                            values[0] = result.attribute(i).name();
                            values[1] = Utils.doubleToString((double)matrix.getMean(0, 0), (int)width, (int)decimals);
                            values[2] = Utils.doubleToString((double)matrix.getStdDev(0, 0), (int)width, (int)decimals);
                            for (n = 0; n < 3; ++n) {
                                if (widths[n] >= values[0].length()) continue;
                                widths[n] = values[0].length();
                            }
                        }
                        StringBuffer outBuff = new StringBuffer();
                        outBuff.append("Runs......: " + ExperimentPanel.this.m_RunsSpinner.getValue() + "\n");
                        outBuff.append("Evaluation: " + ExperimentPanel.this.m_EvalCombo.getSelectedItem() + "\n");
                        if (ExperimentPanel.this.m_EvalCombo.getSelectedIndex() == 0) {
                            outBuff.append("Folds.....: ");
                        } else {
                            outBuff.append("Percentage: ");
                        }
                        outBuff.append(ExperimentPanel.this.m_FoldsPercText.getText() + "\n\n\n");
                        for (int i = 0; i < list.size(); ++i) {
                            values = (String[])list.get(i);
                            for (n = 0; n < values.length; ++n) {
                                int m;
                                if (n > 0) {
                                    for (m = values[n].length(); m < widths[n]; ++m) {
                                        outBuff.append(" ");
                                    }
                                }
                                outBuff.append(values[n]);
                                if (n != 0) continue;
                                for (m = values[n].length(); m < widths[n]; ++m) {
                                    outBuff.append(" ");
                                }
                            }
                            outBuff.append("\n");
                        }
                        String name = ExperimentPanel.this.m_ClassifierEditor.getValue().getClass().getName().replaceAll("weka\\.classifiers\\.", "");
                        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                        name = df.format(new Date()) + " - " + name;
                        ExperimentPanel.this.m_History.addResult(name, outBuff);
                        ExperimentPanel.this.m_History.setSingle(name);
                        ExperimentPanel.this.m_Log.statusMessage("Experiment finished.");
                        ExperimentPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ExperimentPanel.this.m_Log.logMessage(ex.getMessage());
                        GUIHelper.showErrorMessage((Component)ExperimentPanel.this, (String)("Problem running experiment:\n" + LoggingHelper.throwableToString((Throwable)ex)), (String)"Running experiment");
                        ExperimentPanel.this.m_Log.statusMessage("Problem running experiment");
                    }
                    finally {
                        13 var10_17 = this;
                        synchronized (var10_17) {
                            ExperimentPanel.this.m_StartBut.setEnabled(true);
                            ExperimentPanel.this.m_StopBut.setEnabled(false);
                            ExperimentPanel.this.m_RunThread = null;
                        }
                        if (ExperimentPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)ExperimentPanel.this.m_Log).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void stopExperiment() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_ClassifierEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_ClassCombo.getSelectedIndex());
        try {
            filterClass = Capabilities.forInstances((Instances)tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_ClassifierEditor.setCapabilitiesFilter(filterClass);
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Experiment";
    }

    public String getTabTitleToolTip() {
        return "Perform experiments";
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Experiment");
            jf.getContentPane().setLayout(new BorderLayout());
            ExperimentPanel sp = new ExperimentPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog((Logger)lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(GUIHelper.getDefaultDialogDimension());
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances((Reader)r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

