/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka;

import adams.core.Index;
import adams.core.IndexTest;
import adams.core.logging.LoggingHelper;
import adams.data.weka.WekaAttributeIndex;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaAttributeIndexTest
extends IndexTest {
    protected Instances m_Data;

    public WekaAttributeIndexTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.arff";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Data = this.loadDataset(filename);
        this.m_TestHelper.copyResourceToTmp("simple.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("simple.arff");
        super.tearDown();
    }

    protected Instances loadDataset(String filename) throws Exception {
        Instances result = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
        if (result == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
        return result;
    }

    protected Index newIndex(String index, int max) {
        if (index == null) {
            return new WekaAttributeIndex();
        }
        return new WekaAttributeIndex(index, max);
    }

    public void testColumnNames() {
        WekaAttributeIndex index = new WekaAttributeIndex();
        index.setData(null);
        index.setIndex("blah");
        WekaAttributeIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        WekaAttributeIndexTest.assertEquals((String)"should be same", (String)"blah", (String)index.getIndex());
        index.setData((Object)this.m_Data);
        index.setIndex("duration");
        WekaAttributeIndexTest.assertEquals((String)"should be valid", (int)0, (int)index.getIntIndex());
        WekaAttributeIndexTest.assertEquals((String)"should be same", (String)"duration", (String)index.getIndex());
        index.setData((Object)this.m_Data);
        index.setIndex("Duration");
        WekaAttributeIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        WekaAttributeIndexTest.assertEquals((String)"should be same", (String)"Duration", (String)index.getIndex());
        index.setData((Object)this.m_Data);
        index.setIndex("class");
        WekaAttributeIndexTest.assertEquals((String)"should be valid", (int)16, (int)index.getIntIndex());
        WekaAttributeIndexTest.assertEquals((String)"should be same", (String)"class", (String)index.getIndex());
    }

    public void testVariousIndices() {
        Instances data = null;
        try {
            data = this.loadDataset("simple.arff");
        }
        catch (Exception e) {
            WekaAttributeIndexTest.fail((String)("Failed loading simple.arff: " + LoggingHelper.throwableToString((Throwable)e)));
        }
        WekaAttributeIndex index = new WekaAttributeIndex("sample_id");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)0, (int)index.getIntIndex());
        index = new WekaAttributeIndex("\"sample_id\"");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)0, (int)index.getIntIndex());
        index = new WekaAttributeIndex("att1");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)1, (int)index.getIntIndex());
        index = new WekaAttributeIndex("att_2");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)2, (int)index.getIntIndex());
        index = new WekaAttributeIndex("att_3_4");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)3, (int)index.getIntIndex());
        index = new WekaAttributeIndex("\"att_3_4\"");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"wrong index", (int)3, (int)index.getIntIndex());
        index = new WekaAttributeIndex("sampleid");
        index.setData((Object)data);
        WekaAttributeIndexTest.assertEquals((String)"not an index", (int)-1, (int)index.getIntIndex());
    }

    public static Test suite() {
        return new TestSuite(WekaAttributeIndexTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaAttributeIndexTest.runTest((Test)WekaAttributeIndexTest.suite());
    }
}

