/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka;

import adams.core.Index;
import adams.core.IndexTest;
import adams.data.weka.WekaLabelIndex;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaLabelIndexTest
extends IndexTest {
    protected Instances m_Data;

    public WekaLabelIndexTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.arff";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Data = this.loadDataset(filename);
        this.m_TestHelper.copyResourceToTmp("simple.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("simple.arff");
        super.tearDown();
    }

    protected Instances loadDataset(String filename) throws Exception {
        Instances result = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
        if (result == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
        return result;
    }

    protected Index newIndex(String index, int max) {
        if (index == null) {
            return new WekaLabelIndex();
        }
        return new WekaLabelIndex(index, max);
    }

    public void testColumnNames() {
        WekaLabelIndex index = new WekaLabelIndex();
        index.setData(null);
        index.setIndex("blah");
        WekaLabelIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"blah", (String)index.getIndex());
        index.setData((Object)this.m_Data.attribute("pension"));
        index.setIndex("none");
        WekaLabelIndexTest.assertEquals((String)"should be valid", (int)0, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"none", (String)index.getIndex());
        index.setData((Object)this.m_Data.attribute("pension"));
        index.setIndex("\"none\"");
        WekaLabelIndexTest.assertEquals((String)"should be valid", (int)0, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"\"none\"", (String)index.getIndex());
        index.setData((Object)this.m_Data.attribute("pension"));
        index.setIndex("Empl_contr");
        WekaLabelIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"Empl_contr", (String)index.getIndex());
        index.setData((Object)this.m_Data.attribute("pension"));
        index.setIndex("empl_contr");
        WekaLabelIndexTest.assertEquals((String)"should be valid", (int)2, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"empl_contr", (String)index.getIndex());
        index.setData((Object)this.m_Data.attribute("pension"));
        index.setIndex("\"empl_contr\"");
        WekaLabelIndexTest.assertEquals((String)"should be valid", (int)2, (int)index.getIntIndex());
        WekaLabelIndexTest.assertEquals((String)"should be same", (String)"\"empl_contr\"", (String)index.getIndex());
    }

    public static Test suite() {
        return new TestSuite(WekaLabelIndexTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaLabelIndexTest.runTest((Test)WekaLabelIndexTest.suite());
    }
}

