/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.control.SetContainerValue;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaRandomSplit;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AArffLoader;
import weka.core.converters.AbstractFileLoader;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;

public class SetContainerValueTest
extends AbstractFlowTest {
    public SetContainerValueTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("anneal.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("anneal.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.arff")});
    }

    public static Test suite() {
        return new TestSuite(SetContainerValueTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/anneal.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            AArffLoader aarffloader = new AArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)aarffloader);
            actors.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors.add(wekaclassselector);
            WekaRandomSplit wekarandomsplit = new WekaRandomSplit();
            actors.add(wekarandomsplit);
            ContainerValuePicker containervaluepicker = new ContainerValuePicker();
            ArrayList<Object> actors2 = new ArrayList<Object>();
            WekaFilter wekafilter = new WekaFilter();
            Resample resample = new Resample();
            resample.setOptions(OptionUtils.splitOptions((String)"-S 1 -Z 50.0 -no-replacement"));
            wekafilter.setFilter((Filter)resample);
            actors2.add(wekafilter);
            SetStorageValue setstoragevalue = new SetStorageValue();
            argOption = (AbstractArgumentOption)setstoragevalue.getOptionManager().findByProperty("storageName");
            setstoragevalue.setStorageName((StorageName)argOption.valueOf("test"));
            actors2.add(setstoragevalue);
            containervaluepicker.setActors(actors2.toArray(new Actor[0]));
            argOption = (AbstractArgumentOption)containervaluepicker.getOptionManager().findByProperty("valueName");
            containervaluepicker.setValueName((String)argOption.valueOf("Test"));
            actors.add(containervaluepicker);
            SetContainerValue simpleupdatecontainervalue = new SetContainerValue();
            argOption = (AbstractArgumentOption)simpleupdatecontainervalue.getOptionManager().findByProperty("storageName");
            simpleupdatecontainervalue.setStorageName((StorageName)argOption.valueOf("test"));
            simpleupdatecontainervalue.setUseStorage(true);
            argOption = (AbstractArgumentOption)simpleupdatecontainervalue.getOptionManager().findByProperty("valueName");
            simpleupdatecontainervalue.setValueName((BaseString)argOption.valueOf("Test"));
            actors.add(simpleupdatecontainervalue);
            ContainerValuePicker containervaluepicker2 = new ContainerValuePicker();
            argOption = (AbstractArgumentOption)containervaluepicker2.getOptionManager().findByProperty("name");
            containervaluepicker2.setName((String)argOption.valueOf("ContainerValuePicker-1"));
            argOption = (AbstractArgumentOption)containervaluepicker2.getOptionManager().findByProperty("valueName");
            containervaluepicker2.setValueName((String)argOption.valueOf("Test"));
            containervaluepicker2.setSwitchOutputs(true);
            actors.add(containervaluepicker2);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.arff"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SetContainerValueTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SetContainerValueTest.runTest((Test)SetContainerValueTest.suite());
    }
}

