/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.base.BaseString;
import adams.core.logging.LoggingHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MergeManyAttributes;
import weka.filters.unsupervised.attribute.RemoveType;
import weka.test.AdamsTestHelper;

public class MergeManyAttributesTest
extends AbstractAdamsFilterTest {
    public MergeManyAttributesTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        MergeManyAttributes result = new MergeManyAttributes();
        result.setAttributeNames(new BaseString[]{new BaseString("NominalAtt1"), new BaseString("NominalAtt2")});
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        Instances result = new Instances(this.m_Instances);
        RemoveType remove = new RemoveType();
        remove.setAttributeType(new SelectedTag(2, RemoveType.TAGS_ATTRIBUTETYPE));
        remove.setInputFormat(result);
        result = Filter.useFilter((Instances)result, (Filter)remove);
        result.setClassIndex(0);
        return result;
    }

    protected void performThreeAttributesMerge(MergeManyAttributes filter, double[] expected) {
        Instances data = null;
        String filename = "weka/filters/data/MergeManyAttributes.arff";
        try {
            data = new Instances((Reader)new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(filename))));
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            MergeManyAttributesTest.fail((String)("Failed to load dataset '" + filename + "':\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
        filter.setAttributeNames(new BaseString[]{new BaseString("att1"), new BaseString("att2"), new BaseString("att3")});
        try {
            filter.setInputFormat(data);
        }
        catch (Exception e) {
            MergeManyAttributesTest.fail((String)("Failed to call setInputFormat:\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
        Instances output = null;
        try {
            output = Filter.useFilter((Instances)data, (Filter)filter);
        }
        catch (Exception e) {
            MergeManyAttributesTest.fail((String)("Failed to generate output:\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
        MergeManyAttributesTest.assertEquals((String)"# attribute", (int)2, (int)output.numAttributes());
        MergeManyAttributesTest.assertEquals((String)"class attribute", (int)1, (int)output.classIndex());
        MergeManyAttributesTest.assertEquals((String)"number of instances", (int)data.numInstances(), (int)output.numInstances());
        double[] values = output.attributeToDoubleArray(0);
        for (int i = 0; i < values.length; ++i) {
            MergeManyAttributesTest.assertEquals((String)("value #" + (i + 1) + " differs"), (Object)expected[i], (Object)values[i]);
        }
    }

    public void testMergeThreeAttributes() {
        MergeManyAttributes filter = new MergeManyAttributes();
        this.performThreeAttributesMerge(filter, new double[]{1.0, Utils.missingValue(), Utils.missingValue(), Utils.missingValue(), Utils.missingValue()});
        filter = new MergeManyAttributes();
        filter.setDiffer(new SelectedTag(1, MergeManyAttributes.TAGS_VALUESDIFFER));
        this.performThreeAttributesMerge(filter, new double[]{1.0, 2.0, Utils.missingValue(), Utils.missingValue(), Utils.missingValue()});
        filter = new MergeManyAttributes();
        filter.setOneMissing(new SelectedTag(1, MergeManyAttributes.TAGS_ONEMISSING));
        this.performThreeAttributesMerge(filter, new double[]{1.0, Utils.missingValue(), 1.0, 2.0, Utils.missingValue()});
    }

    public static Test suite() {
        return new TestSuite(MergeManyAttributesTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)MergeManyAttributesTest.suite());
    }
}

