/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RowSum;
import weka.test.AdamsTestHelper;

public class RowSumTest
extends AbstractAdamsFilterTest {
    public RowSumTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new RowSum();
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RowSumTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            RowSumTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RowSumTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        RowSum filter = (RowSum)this.m_Filter;
        RowSumTest.assertEquals((int)2, (int)result.numAttributes());
        RowSumTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(RowSumTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)RowSumTest.suite());
    }
}

