/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.M5P;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.KennardStone;
import weka.test.AdamsTestHelper;

public class KennardStoneTest
extends AbstractAdamsFilterTest {
    public KennardStoneTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier((Classifier)new M5P());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(0);
        testinst.setNumInstances(200);
        return testinst.generate();
    }

    public Filter getFilter() {
        KennardStone result = new KennardStone();
        result.setNumberInSubset(30);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KennardStoneTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            KennardStoneTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KennardStoneTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        KennardStoneTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        KennardStoneTest.assertEquals((int)30, (int)result.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(KennardStoneTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)KennardStoneTest.suite());
    }
}

