/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery.genetic;

import adams.core.base.BaseClassname;
import adams.core.discovery.IntrospectionHelper;
import adams.core.discovery.PropertyPath;
import adams.core.discovery.genetic.AbstractGeneticFloatDiscoveryHandlerResolution;
import adams.core.option.UserMode;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.classifiers.functions.GPD;

public class GenericFloatResolution
extends AbstractGeneticFloatDiscoveryHandlerResolution {
    private static final long serialVersionUID = 9168998412950337023L;
    protected BaseClassname m_Classname;
    protected transient Class m_ActualClass;
    protected String m_Property;
    protected transient PropertyDescriptor m_PropertyDescriptor;

    public String globalInfo() {
        return "Generic handler for float properties (using resolution).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classname", "classname", (Object)this.getDefaultClassname());
        this.m_OptionManager.add("property", "property", (Object)this.getDefaultProperty());
    }

    protected void reset() {
        super.reset();
        this.m_ActualClass = null;
        this.m_PropertyDescriptor = null;
    }

    protected int getDefaultSplits() {
        return 4;
    }

    protected float getDefaultMinimum() {
        return 0.01f;
    }

    protected float getDefaultMaximum() {
        return 0.04f;
    }

    protected String getDefaultList() {
        return "0.01 0.02 0.03 0.04";
    }

    protected BaseClassname getDefaultClassname() {
        return new BaseClassname(GPD.class);
    }

    public void setClassname(BaseClassname value) {
        this.m_Classname = value;
        this.reset();
    }

    public BaseClassname getClassname() {
        return this.m_Classname;
    }

    public String classnameTipText() {
        return "The classname of the objects to handle.";
    }

    protected String getDefaultProperty() {
        return "gamma";
    }

    public void setProperty(String value) {
        this.m_Property = value;
        this.reset();
    }

    public String getProperty() {
        return this.m_Property;
    }

    public String propertyTipText() {
        return "The property of the objects to manage.";
    }

    protected synchronized Class getActualClass() {
        if (this.m_ActualClass == null) {
            this.m_ActualClass = this.m_Classname.classValue();
            if (this.m_ActualClass == null) {
                throw new IllegalStateException("No valid class name provided? " + this.m_Classname);
            }
        }
        return this.m_ActualClass;
    }

    protected synchronized PropertyDescriptor getPropertyDescriptor() {
        if (this.m_PropertyDescriptor == null) {
            try {
                IntrospectionHelper.IntrospectionContainer cont = IntrospectionHelper.introspect((Class)this.getActualClass(), (UserMode)UserMode.HIGHEST);
                for (PropertyDescriptor pd : cont.properties) {
                    if (!pd.getDisplayName().equals(this.m_Property)) continue;
                    this.m_PropertyDescriptor = pd;
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to introspect: " + this.m_Classname + "/" + this.m_Property, e);
            }
        }
        return this.m_PropertyDescriptor;
    }

    protected float getValue(PropertyPath.PropertyContainer cont) {
        Float result;
        PropertyDescriptor pd = this.getPropertyDescriptor();
        Method method = pd.getReadMethod();
        try {
            result = (Float)method.invoke(cont.getObject(), new Object[0]);
            if (result == null) {
                throw new IllegalStateException("Property '" + this.m_Property + "' of class '" + this.m_Classname + "' returned null!");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to get value from property '" + this.m_Property + "' of class '" + this.m_Classname + "'!", (Throwable)e);
            result = Float.valueOf(Float.NaN);
        }
        return result.floatValue();
    }

    protected void setValue(PropertyPath.PropertyContainer cont, float value) {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        Method method = pd.getWriteMethod();
        try {
            method.invoke(cont.getObject(), Float.valueOf(value));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to set value '" + value + "' for property '" + this.m_Property + "' of class '" + this.m_Classname + "'!", (Throwable)e);
        }
    }

    protected boolean handles(Object obj) {
        return ClassLocator.isSubclass((Class)this.getActualClass(), obj.getClass()) || ClassLocator.hasInterface((Class)this.getActualClass(), obj.getClass());
    }
}

