/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.base.BaseRegExp;
import adams.data.instancesanalysis.pls.AbstractPLS;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public abstract class AbstractMultiClassPLS
extends AbstractPLS {
    private static final long serialVersionUID = 5649007256147616278L;
    public static final String PARAM_CLASSVALUES = "classValues";
    protected BaseRegExp m_ClassAttributes = this.getDefaultClassAttributes();
    protected Filter m_Missing;
    protected Filter m_Filter;
    protected TIntList m_ClassAttributeIndices;
    protected Map<Integer, Double> m_ClassMean;
    protected Map<Integer, Double> m_ClassStdDev;

    @Override
    public void reset() {
        super.reset();
        this.m_Missing = null;
        this.m_Filter = null;
        this.m_ClassAttributeIndices = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class-attributes", "classAttributes", (Object)new BaseRegExp(""));
    }

    protected BaseRegExp getDefaultClassAttributes() {
        return new BaseRegExp("");
    }

    public void setClassAttributes(BaseRegExp value) {
        this.m_ClassAttributes = value;
        this.reset();
    }

    public BaseRegExp getClassAttributes() {
        return this.m_ClassAttributes;
    }

    public String classAttributesTipText() {
        return "The regular expression for identifying the class attributes (besides an explicitly set one).";
    }

    @Override
    public Instances determineOutputFormat(Instances input) throws Exception {
        int i;
        this.m_ClassAttributeIndices = new TIntArrayList();
        ArrayList<String> classes = new ArrayList<String>();
        for (i = 0; i < input.numAttributes(); ++i) {
            if (!this.m_ClassAttributes.isMatch(input.attribute(i).name())) continue;
            classes.add(input.attribute(i).name());
            this.m_ClassAttributeIndices.add(i);
        }
        if (!classes.contains(input.classAttribute().name())) {
            classes.add(input.classAttribute().name());
            this.m_ClassAttributeIndices.add(input.classAttribute().index());
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        String prefix = this.getClass().getSimpleName();
        for (i = 0; i < this.getNumComponents(); ++i) {
            atts.add(new Attribute(prefix + "_" + (i + 1)));
        }
        for (String cls : classes) {
            atts.add(new Attribute(cls));
        }
        Instances result = new Instances(prefix, atts, 0);
        result.setClassIndex(result.numAttributes() - 1);
        this.m_OutputFormat = result;
        return result;
    }

    @Override
    protected Instances preTransform(Instances instances, Map<String, Object> params) throws Exception {
        int index;
        int i;
        HashMap<Integer, double[]> classValues;
        switch (this.m_PredictionType) {
            case ALL: {
                classValues = null;
                break;
            }
            default: {
                classValues = new HashMap<Integer, double[]>();
                for (i = 0; i < this.m_ClassAttributeIndices.size(); ++i) {
                    index = this.m_ClassAttributeIndices.get(i);
                    classValues.put(index, instances.attributeToDoubleArray(index));
                }
            }
        }
        if (classValues != null) {
            params.put(PARAM_CLASSVALUES, classValues);
        }
        if (!this.isInitialized()) {
            if (this.m_ReplaceMissing) {
                this.m_Missing = new ReplaceMissingValues();
                this.m_Missing.setInputFormat(instances);
            } else {
                this.m_Missing = null;
            }
            this.m_ClassMean = new HashMap<Integer, Double>();
            this.m_ClassStdDev = new HashMap<Integer, Double>();
            block9: for (i = 0; i < this.m_ClassAttributeIndices.size(); ++i) {
                index = this.m_ClassAttributeIndices.get(i);
                switch (this.m_PreprocessingType) {
                    case CENTER: {
                        this.m_ClassMean.put(index, instances.meanOrMode(index));
                        this.m_ClassStdDev.put(index, 1.0);
                        this.m_Filter = new Center();
                        ((Center)this.m_Filter).setIgnoreClass(true);
                        continue block9;
                    }
                    case STANDARDIZE: {
                        this.m_ClassMean.put(index, instances.meanOrMode(index));
                        this.m_ClassStdDev.put(index, StrictMath.sqrt(instances.variance(index)));
                        this.m_Filter = new Standardize();
                        ((Standardize)this.m_Filter).setIgnoreClass(true);
                        continue block9;
                    }
                    case NONE: {
                        this.m_ClassMean.put(index, 0.0);
                        this.m_ClassStdDev.put(index, 1.0);
                        this.m_Filter = null;
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled preprocessing type; " + this.m_PreprocessingType);
                    }
                }
            }
            if (this.m_Filter != null) {
                this.m_Filter.setInputFormat(instances);
            }
        }
        if (this.m_Missing != null) {
            instances = Filter.useFilter((Instances)instances, (Filter)this.m_Missing);
        }
        if (this.m_Filter != null) {
            instances = Filter.useFilter((Instances)instances, (Filter)this.m_Filter);
        }
        return instances;
    }

    @Override
    protected Instances postTransform(Instances instances, Map<String, Object> params) throws Exception {
        Map classValues = (Map)params.get(PARAM_CLASSVALUES);
        for (int i = 0; i < this.m_ClassAttributeIndices.size(); ++i) {
            int index = this.m_ClassAttributeIndices.get(i);
            for (int n = 0; n < instances.numInstances(); ++n) {
                if (classValues != null) {
                    instances.instance(n).setClassValue(((double[])classValues.get(index))[n]);
                    continue;
                }
                double classValue = instances.instance(n).classValue();
                instances.instance(n).setClassValue(classValue * this.m_ClassStdDev.get(index) + this.m_ClassMean.get(index));
            }
        }
        return instances;
    }
}

