/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.base.BaseCharset;
import adams.core.io.EncodingSupporter;
import adams.core.io.PlaceholderFile;
import adams.core.option.NestedConsumer;
import adams.data.io.input.AbstractAdamsExperimentReader;
import adams.data.io.output.AbstractAdamsExperimentWriter;
import adams.data.io.output.NestedAdamsExperimentWriter;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import java.io.File;
import java.util.logging.Level;

public class NestedAdamsExperimentReader
extends AbstractAdamsExperimentReader
implements EncodingSupporter {
    private static final long serialVersionUID = 7175000296488786947L;
    protected BaseCharset m_Encoding;

    public String globalInfo() {
        return "Reads ADAMS Experiments in nested format.";
    }

    @Override
    public String getFormatDescription() {
        return "Nested format experiment";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"expnest"};
    }

    @Override
    public AbstractAdamsExperimentWriter getCorrespondingWriter() {
        return new NestedAdamsExperimentWriter();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    @Override
    protected AbstractExperiment doRead(PlaceholderFile file) {
        NestedConsumer consumer = new NestedConsumer();
        consumer.setEncoding(this.m_Encoding);
        try {
            return (AbstractExperiment)consumer.fromFile((File)file);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from: " + file, (Throwable)e);
            return null;
        }
    }
}

