/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeRange;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;

public class WekaAttributeSummary
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1970232977500522747L;
    protected WekaAttributeRange m_Range;
    protected BaseTabbedPane m_TabbedPane;
    protected AttributeVisualizationPanel m_PanelAtt;

    public String globalInfo() {
        return "Displays an attribute summary.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new WekaAttributeRange("first-last"));
    }

    protected int getDefaultWidth() {
        return 600;
    }

    protected int getDefaultHeight() {
        return 400;
    }

    public void setRange(WekaAttributeRange value) {
        this.m_Range = value;
        this.reset();
    }

    public WekaAttributeRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of attributes to visualize.";
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"range", (Object)((Object)this.m_Range), (String)", atts: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel();
        result.setLayout((LayoutManager)new BorderLayout());
        return result;
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        this.m_Panel.removeAll();
    }

    protected void display(Token token) {
        Instances inst = (Instances)token.getPayload();
        this.m_Range.setData(inst);
        int[] indices = this.m_Range.getIntIndices();
        this.clearPanel();
        if (indices.length == 1) {
            this.m_PanelAtt = new AttributeVisualizationPanel();
            this.m_PanelAtt.setInstances(inst);
            this.m_PanelAtt.setAttribute(indices[0]);
            this.m_Panel.add((Component)this.m_PanelAtt, (Object)"Center");
        } else if (indices.length > 1) {
            this.m_TabbedPane = new BaseTabbedPane();
            this.m_Panel.add((Component)this.m_TabbedPane, (Object)"Center");
            for (int index : indices) {
                AttributeVisualizationPanel panel = new AttributeVisualizationPanel();
                panel.setInstances(inst);
                panel.setAttribute(index);
                this.m_TabbedPane.addTab(inst.attribute(index).name(), (Component)panel);
            }
        }
    }

    public JComponent supplyComponent() {
        if (this.m_TabbedPane != null) {
            return this.m_TabbedPane;
        }
        return this.m_PanelAtt;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected BaseTabbedPane m_TabbedPane;
            protected AttributeVisualizationPanel m_PanelAtt;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_PanelAtt = new AttributeVisualizationPanel();
                this.add((Component)this.m_PanelAtt, "Center");
            }

            public void display(Token token) {
                Instances inst = (Instances)token.getPayload();
                WekaAttributeSummary.this.m_Range.setData(inst);
                int[] indices = WekaAttributeSummary.this.m_Range.getIntIndices();
                this.clearPanel();
                if (indices.length == 1) {
                    this.m_PanelAtt = new AttributeVisualizationPanel();
                    this.m_PanelAtt.setInstances(inst);
                    this.m_PanelAtt.setAttribute(indices[0]);
                    WekaAttributeSummary.this.m_Panel.add((Component)this.m_PanelAtt, (Object)"Center");
                } else if (indices.length > 1) {
                    this.m_TabbedPane = new BaseTabbedPane();
                    WekaAttributeSummary.this.m_Panel.add((Component)this.m_TabbedPane, (Object)"Center");
                    for (int index : indices) {
                        AttributeVisualizationPanel panel = new AttributeVisualizationPanel();
                        panel.setInstances(inst);
                        panel.setAttribute(index);
                        this.m_TabbedPane.addTab(inst.attribute(index).name(), (Component)panel);
                    }
                }
            }

            public void cleanUp() {
            }

            public void clearPanel() {
                this.removeAll();
            }

            public JComponent supplyComponent() {
                if (this.m_TabbedPane != null) {
                    return this.m_TabbedPane;
                }
                return this.m_PanelAtt;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

