/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.classifiers.AggregateEvaluations;
import weka.classifiers.Evaluation;

public class WekaAggregateEvaluations
extends AbstractTransformer {
    private static final long serialVersionUID = 3799673803958040769L;
    public static final String BACKUP_EVALUATION = "evaluation";
    protected AggregateEvaluations m_Evaluation;

    public String globalInfo() {
        return "Aggregates incoming " + Evaluation.class.getName() + " objects and forwards the current aggregated state.\nOnly works with the predictions stored in the evaluation object.\nNB: Relative absolute error and Root relative squared error will differ a bit.";
    }

    protected void reset() {
        super.reset();
        this.m_Evaluation = null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_EVALUATION);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_EVALUATION, this.m_Evaluation);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_EVALUATION)) {
            this.m_Evaluation = (AggregateEvaluations)((Object)state.get(BACKUP_EVALUATION));
            state.remove(BACKUP_EVALUATION);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaEvaluationContainer.class};
    }

    protected String doExecute() {
        String result = null;
        Evaluation input = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        try {
            if (this.m_Evaluation == null) {
                this.m_Evaluation = new AggregateEvaluations();
            }
            this.m_Evaluation.add(input);
            Evaluation agg = this.m_Evaluation.aggregated();
            if (agg == null) {
                result = this.m_Evaluation.hasLastError() ? this.m_Evaluation.getLastError() : "Failed to aggregate predictions!";
            }
            if (agg != null) {
                this.m_OutputToken = new Token((Object)agg);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to aggregate evaluation!", e);
        }
        return result;
    }
}

