/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import weka.core.Instance;
import weka.core.Instances;

public class WekaAttributeIterator
extends AbstractArrayProvider {
    private static final long serialVersionUID = 7689330704841468990L;
    protected Range m_Range;
    protected BaseRegExp m_RegExp;
    protected boolean m_OutputIndices;

    public String globalInfo() {
        return "Iterates through all attributes of a dataset and outputs the names.\nThe attributes can be limited with the range parameter and furthermore with the regular expression applied to the names.\nInstead of outputting the names, it is also possible to output the 1-based indices.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new Range("first-last"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("output-indices", "outputIndices", (Object)false);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"range", (Object)this.m_Range);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", subset: ");
        if (value != null) {
            result = (String)result + value;
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputIndices", (boolean)this.m_OutputIndices, (String)"output indices", (String)", ");
        return result;
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the names/indices as an array rather than one-by-one.";
    }

    public void setRange(Range value) {
        this.m_Range = value;
        this.reset();
    }

    public Range getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of attributes to iterate over; " + this.m_Range.getExample() + ".";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used to further limit the attribute set.";
    }

    public void setOutputIndices(boolean value) {
        this.m_OutputIndices = value;
        this.reset();
    }

    public boolean getOutputIndices() {
        return this.m_OutputIndices;
    }

    public String outputIndicesTipText() {
        return "If set to true, 1-based indices of matches are output instead of names.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    protected Class getItemClass() {
        return String.class;
    }

    protected String doExecute() {
        String result = null;
        Instances data = this.m_InputToken.getPayload() instanceof Instance ? ((Instance)this.m_InputToken.getPayload()).dataset() : (Instances)this.m_InputToken.getPayload();
        this.m_Range.setMax(data.numAttributes());
        int[] indices = this.m_Range.getIntIndices();
        boolean useRegExp = !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatchAll();
        this.m_Queue.clear();
        for (int index : indices) {
            String name = data.attribute(index).name();
            if (useRegExp && !this.m_RegExp.isMatch(name)) continue;
            if (this.m_OutputIndices) {
                this.m_Queue.add("" + (index + 1));
                continue;
            }
            this.m_Queue.add(name);
        }
        return result;
    }
}

