/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.core.Drawable;

public class WekaClassifierInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected String m_SourceCodeClass;

    public String globalInfo() {
        return "Outputs information of a trained weka.classifiers.Classifier object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.MODEL);
        this.m_OptionManager.add("source-code-class", "sourceCodeClass", (Object)"WekaClassifierModel");
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sourceCodeClass", (Object)this.m_SourceCodeClass, (String)", class: ");
        return result;
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setSourceCodeClass(String value) {
        this.m_SourceCodeClass = value;
        this.reset();
    }

    public String getSourceCodeClass() {
        return this.m_SourceCodeClass;
    }

    public String sourceCodeClassTipText() {
        return "The name of the Java class when generating source code.";
    }

    public Class[] accepts() {
        return new Class[]{Classifier.class, WekaModelContainer.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case MODEL: 
            case GRAPH: 
            case SOURCE_CODE: {
                return new Class[]{String.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    protected String doExecute() {
        Object result = null;
        Classifier cls = null;
        if (this.m_InputToken.getPayload() instanceof Classifier) {
            cls = (Classifier)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
            cls = (Classifier)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model");
        } else {
            result = "Unhandled class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            switch (this.m_Type) {
                case MODEL: {
                    this.m_OutputToken = new Token((Object)cls.toString());
                    break;
                }
                case GRAPH: {
                    try {
                        if (!(cls instanceof Drawable)) break;
                        this.m_OutputToken = new Token((Object)((Drawable)cls).graph());
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to obtain graph from classifier!", e);
                    }
                    break;
                }
                case SOURCE_CODE: {
                    try {
                        if (!(cls instanceof Sourcable)) break;
                        this.m_OutputToken = new Token((Object)((Sourcable)cls).toSource(this.m_SourceCodeClass));
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to obtain source code from classifier!", e);
                    }
                    break;
                }
                default: {
                    result = "Unhandled info type: " + this.m_Type;
                }
            }
        }
        return result;
    }

    public static enum InfoType {
        MODEL,
        GRAPH,
        SOURCE_CODE;

    }
}

