/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class WekaEvaluationInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -4898802545222942458L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs information about a Weka " + Evaluation.class.getName() + " object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.RELATION_NAME);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case RELATION_NAME: 
            case CLASS_ATTRIBUTE_NAME: {
                return new Class[]{String.class};
            }
            case HEADER: {
                return new Class[]{Instances.class};
            }
            case PREDICTIONS_RECORDED: {
                return new Class[]{Boolean.class};
            }
            case NUM_PREDICTIONS: {
                return new Class[]{Integer.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    protected String doExecute() {
        Evaluation eval = this.m_InputToken.getPayload() instanceof Evaluation ? (Evaluation)this.m_InputToken.getPayload() : (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation");
        switch (this.m_Type) {
            case RELATION_NAME: {
                this.m_OutputToken = new Token((Object)eval.getHeader().relationName());
                break;
            }
            case CLASS_ATTRIBUTE_NAME: {
                this.m_OutputToken = new Token((Object)eval.getHeader().classAttribute().name());
                break;
            }
            case HEADER: {
                this.m_OutputToken = new Token((Object)eval.getHeader());
                break;
            }
            case PREDICTIONS_RECORDED: {
                this.m_OutputToken = new Token((Object)(eval.predictions() != null ? 1 : 0));
                break;
            }
            case NUM_PREDICTIONS: {
                if (eval.predictions() == null) {
                    this.m_OutputToken = new Token((Object)-1);
                    break;
                }
                this.m_OutputToken = new Token((Object)eval.predictions().size());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled info type: " + this.m_Type);
            }
        }
        return null;
    }

    public static enum InfoType {
        RELATION_NAME,
        HEADER,
        CLASS_ATTRIBUTE_NAME,
        PREDICTIONS_RECORDED,
        NUM_PREDICTIONS;

    }
}

