/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.BufferSupporter;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.FlushSupporter;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.CSVLoader;

public class WekaInstanceDumper
extends AbstractTransformer
implements BufferSupporter,
FlushSupporter {
    private static final long serialVersionUID = 5071747277597147724L;
    public static final String BACKUP_HEADER = "header";
    public static final String BACKUP_COUNTER = "counter";
    public static final String BACKUP_BUFFER = "buffer";
    protected Instances m_Header;
    protected int m_Counter;
    protected boolean m_CheckHeader;
    protected PlaceholderFile m_OutputPrefix;
    protected OutputFormat m_OutputFormat;
    protected boolean m_UseRelationNameAsFilename;
    protected boolean m_KeepExisting;
    protected int m_BufferSize;
    protected List<Instance> m_Buffer;

    public String globalInfo() {
        return "Dumps weka.core.Instance objects into an ARFF file. If the headers change and the header-check is enabled, then a new file will be used.\nThe actor can also turn double arrays into weka.core.Instance objects (all attributes are assumed to be numeric).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("check", "checkHeader", (Object)false);
        this.m_OptionManager.add("prefix", "outputPrefix", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("format", "outputFormat", (Object)OutputFormat.ARFF);
        this.m_OptionManager.add("use-relation", "useRelationNameAsFilename", (Object)false);
        this.m_OptionManager.add("keep-existing", "keepExisting", (Object)false);
        this.m_OptionManager.add("buffer-size", "bufferSize", (Object)1, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Buffer = new ArrayList<Instance>();
    }

    public String getQuickInfo() {
        String result = this.m_OutputFormat.toString() + ": ";
        String variable = QuickInfoHelper.getVariable((OptionHandler)this, (String)"outputPrefix");
        result = variable != null ? (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useRelationNameAsFilename") || this.m_UseRelationNameAsFilename ? result + variable + " using <relation>" : result + variable) : (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useRelationNameAsFilename") || this.m_UseRelationNameAsFilename ? result + new PlaceholderFile(this.m_OutputPrefix.getParent()).toString() + File.separator + "<relation>" : result + this.m_OutputPrefix);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"bufferSize", (Object)(this.m_BufferSize > 1 ? Integer.valueOf(this.m_BufferSize) : null), (String)", buffering: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setCheckHeader(boolean value) {
        this.m_CheckHeader = value;
        this.reset();
    }

    public boolean getCheckHeader() {
        return this.m_CheckHeader;
    }

    public String checkHeaderTipText() {
        return "Whether to check the headers - if the headers change, the Instance object gets dumped into a new file.";
    }

    public void setOutputPrefix(PlaceholderFile value) {
        String prefix = value.toString();
        if (prefix.toLowerCase().endsWith(".gz")) {
            value = new PlaceholderFile(prefix.substring(0, prefix.lastIndexOf(46)));
            prefix = value.toString();
        }
        if (prefix.toLowerCase().endsWith(".arff") || prefix.toLowerCase().endsWith(".csv")) {
            value = new PlaceholderFile(prefix.substring(0, prefix.lastIndexOf(46)));
        }
        this.m_OutputPrefix = value;
        this.reset();
    }

    public PlaceholderFile getOutputPrefix() {
        return this.m_OutputPrefix;
    }

    public String outputPrefixTipText() {
        return "The path and partial filename of the output file; automatically removes 'arff' and 'csv' extensions, as they get added automatically.";
    }

    public void setOutputFormat(OutputFormat value) {
        this.m_OutputFormat = value;
        this.reset();
    }

    public OutputFormat getOutputFormat() {
        return this.m_OutputFormat;
    }

    public String outputFormatTipText() {
        return "The format to output the data in.";
    }

    public void setUseRelationNameAsFilename(boolean value) {
        this.m_UseRelationNameAsFilename = value;
        this.reset();
    }

    public boolean getUseRelationNameAsFilename() {
        return this.m_UseRelationNameAsFilename;
    }

    public String useRelationNameAsFilenameTipText() {
        return "If set to true, then the relation name replaces the name of the output file; eg if the output file is '/some/where/file.arff' and the relation is 'anneal' then the resulting file name will be '/some/where/anneal.arff'.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the actor is executed for the first time (or variables modify the actor) won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of attributes, etc).";
    }

    public void setBufferSize(int value) {
        if (this.getOptionManager().isValid("bufferSize", (Number)value)) {
            this.m_BufferSize = value;
            this.reset();
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The number of instances to buffer before writing to disk, in order to improve I/O performance.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_HEADER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Header != null) {
            result.put(BACKUP_HEADER, this.m_Header);
            result.put(BACKUP_COUNTER, this.m_Counter);
            result.put(BACKUP_BUFFER, this.m_Buffer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_HEADER)) {
            this.m_Header = (Instances)state.get(BACKUP_HEADER);
            state.remove(BACKUP_HEADER);
        }
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        if (state.containsKey(BACKUP_BUFFER)) {
            this.m_Buffer = (List)state.get(BACKUP_BUFFER);
            state.remove(BACKUP_BUFFER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_Header = null;
        this.m_Buffer.clear();
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, double[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        File file;
        Object result = super.setUp();
        if (result == null && !(file = new File(this.m_OutputPrefix.getAbsolutePath())).getParentFile().exists()) {
            result = "Parent directory does not exist: " + file.getParentFile();
        }
        return result;
    }

    protected File createFilename(Instances header) {
        Object result;
        if (this.m_UseRelationNameAsFilename) {
            File file = new File(this.m_OutputPrefix.getAbsolutePath());
            result = file.getParent() + File.separator + FileUtils.createFilename((String)header.relationName(), (String)"_");
        } else {
            result = this.m_OutputPrefix.getAbsolutePath();
        }
        if (this.m_Counter > 0) {
            result = (String)result + "-" + this.m_Counter;
        }
        switch (this.m_OutputFormat) {
            case ARFF: {
                result = (String)result + ArffLoader.FILE_EXTENSION;
                break;
            }
            case CSV: {
                result = (String)result + CSVLoader.FILE_EXTENSION;
                break;
            }
            case TAB: {
                result = (String)result + CSVLoader.FILE_EXTENSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + this.m_OutputFormat);
            }
        }
        return new File((String)result);
    }

    protected String createHeader(Instances header) {
        StringBuilder result = new StringBuilder();
        switch (this.m_OutputFormat) {
            case ARFF: {
                result.append(new Instances(header, 0).toString());
                break;
            }
            case CSV: {
                for (int i = 0; i < header.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    result.append(Utils.quote((String)header.attribute(i).name()));
                }
                break;
            }
            case TAB: {
                for (int i = 0; i < header.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append("\t");
                    }
                    result.append(Utils.quote((String)header.attribute(i).name()));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + this.m_OutputFormat);
            }
        }
        return result.toString();
    }

    protected String createRow(Instance row) {
        StringBuilder result = new StringBuilder();
        switch (this.m_OutputFormat) {
            case ARFF: {
                result.append(row.toString());
                break;
            }
            case CSV: {
                for (int i = 0; i < row.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    result.append(row.toString(i));
                }
                break;
            }
            case TAB: {
                for (int i = 0; i < row.numAttributes(); ++i) {
                    if (i > 0) {
                        result.append("\t");
                    }
                    result.append(row.toString(i));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output format: " + this.m_OutputFormat);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String writeToDisk(boolean append) {
        Object result = null;
        File outputFile = this.createFilename(this.m_Buffer.get(0).dataset());
        if (!outputFile.getParentFile().exists()) {
            result = "Parent directory does not exist: " + outputFile.getParentFile();
            return result;
        }
        boolean ok = true;
        if (!outputFile.exists() || !append) {
            ok = FileUtils.writeToFile((String)outputFile.getAbsolutePath(), (Object)this.createHeader(this.m_Buffer.get(0).dataset()), (boolean)false);
        }
        if (ok) {
            FileWriter fwriter = null;
            BufferedWriter writer = null;
            try {
                fwriter = new FileWriter(outputFile.getAbsolutePath(), true);
                writer = new BufferedWriter(fwriter);
                while (this.m_Buffer.size() > 0) {
                    writer.append(this.createRow(this.m_Buffer.get(0)));
                    writer.newLine();
                    this.m_Buffer.remove(0);
                }
                writer.flush();
            }
            catch (Exception e) {
                try {
                    result = this.handleException("Failed to write to '" + outputFile + "': ", e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(fwriter);
                    FileUtils.closeQuietly(writer);
                    throw throwable;
                }
                FileUtils.closeQuietly((Writer)fwriter);
                FileUtils.closeQuietly((Writer)writer);
            }
            FileUtils.closeQuietly((Writer)fwriter);
            FileUtils.closeQuietly((Writer)writer);
        }
        return result;
    }

    protected String updateVariables() {
        this.performFlush();
        return super.updateVariables();
    }

    protected String doExecute() {
        Instances newHeader;
        Instance inst;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = (Instance)this.m_InputToken.getPayload();
            newHeader = inst.dataset();
        } else {
            double[] values = (double[])this.m_InputToken.getPayload();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < values.length; ++i) {
                atts.add(new Attribute("att_" + (i + 1)));
            }
            newHeader = new Instances(this.getName(), atts, 0);
            inst = new DenseInstance(1.0, values);
            inst.setDataset(newHeader);
        }
        boolean append = true;
        if (this.m_Header == null) {
            this.m_Header = new Instances(newHeader, 0);
            if (!this.m_KeepExisting) {
                append = false;
            }
        } else if (this.m_CheckHeader && !this.m_Header.equalHeaders(newHeader)) {
            ++this.m_Counter;
            this.m_Header = new Instances(newHeader, 0);
            append = false;
        }
        if (!append) {
            FileUtils.delete((String)this.createFilename(inst.dataset()).getAbsolutePath());
        }
        this.m_Buffer.add(inst);
        if (this.m_Buffer.size() >= this.m_BufferSize) {
            result = this.writeToDisk(append);
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.createFilename(inst.dataset()).getAbsolutePath());
        }
        return result;
    }

    public void wrapUp() {
        this.performFlush();
        super.wrapUp();
        this.m_Header = null;
    }

    public void performFlush() {
        if (this.m_Buffer.size() > 0) {
            this.writeToDisk(true);
        }
    }

    public static enum OutputFormat {
        ARFF,
        CSV,
        TAB;

    }
}

