/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.LenientModeSupporter;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.DynamicInitializer;
import adams.flow.core.OptionalOneTimeInitializer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.attribute.Reorder;

public class WekaReorderAttributesToReference
extends AbstractTransformer
implements OptionalOneTimeInitializer,
DynamicInitializer,
LenientModeSupporter {
    private static final long serialVersionUID = 530323409335629567L;
    public static final String BACKUP_REFERENCE = "reference";
    public static final String BACKUP_REORDER = "reorder";
    protected PlaceholderFile m_ReferenceFile;
    protected boolean m_UseCustomLoader;
    protected AbstractFileLoader m_CustomLoader;
    protected CallableActorReference m_ReferenceActor;
    protected Instances m_Reference;
    protected boolean m_OnTheFly;
    protected boolean m_InitializeOnce;
    protected boolean m_Lenient;
    protected boolean m_KeepRelationName;
    protected MultiFilter m_Reorder;

    public String globalInfo() {
        return "Reorders the attributes of the Instance/Instances passing through according to the provided reference dataset (callable actor or reference file).\nThis ensures that the generated data always has the same structure as the reference dataset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reference-file", "referenceFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("use-custom", "useCustomLoader", (Object)false);
        this.m_OptionManager.add("loader", "customLoader", (Object)new ArffLoader());
        this.m_OptionManager.add("reference-actor", "referenceActor", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
        this.m_OptionManager.add("init-once", "initializeOnce", (Object)false);
        this.m_OptionManager.add("lenient", "lenient", (Object)false);
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Reference = null;
        this.m_Reorder = null;
    }

    public void setReferenceFile(PlaceholderFile value) {
        this.m_ReferenceFile = value;
        this.reset();
    }

    public PlaceholderFile getReferenceFile() {
        return this.m_ReferenceFile;
    }

    public String referenceFileTipText() {
        return "The reference dataset to load (when not pointing to a directory).";
    }

    public void setUseCustomLoader(boolean value) {
        this.m_UseCustomLoader = value;
        this.reset();
    }

    public boolean getUseCustomLoader() {
        return this.m_UseCustomLoader;
    }

    public String useCustomLoaderTipText() {
        return "If set to true, then the custom loader will be used for loading the data.";
    }

    public void setCustomLoader(AbstractFileLoader value) {
        this.m_CustomLoader = value;
        this.reset();
    }

    public AbstractFileLoader getCustomLoader() {
        return this.m_CustomLoader;
    }

    public String customLoaderTipText() {
        return "The custom loader to use if enabled.";
    }

    public void setReferenceActor(CallableActorReference value) {
        this.m_ReferenceActor = value;
        this.reset();
    }

    public CallableActorReference getReferenceActor() {
        return this.m_ReferenceActor;
    }

    public String referenceActorTipText() {
        return "The callable actor to use for obtaining the reference dataset in case reference file points to a directory.";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the reference file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public void setInitializeOnce(boolean value) {
        this.m_InitializeOnce = value;
        this.reset();
    }

    public boolean getInitializeOnce() {
        return this.m_InitializeOnce;
    }

    public String initializeOnceTipText() {
        return "If set to true, then the internal reorder filter will get initialized only with the first batch of data; otherwise every time data gets passed through.";
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If set to true, attributes from the reference data that are missing in the incoming data get tolerated.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"referenceFile", (Object)this.m_ReferenceFile, (String)"file: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"referenceActor", (Object)this.m_ReferenceActor, (String)", actor: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useCustomLoader", (boolean)this.getUseCustomLoader(), (String)this.m_CustomLoader.getClass().getSimpleName()));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"onTheFly", (boolean)this.m_OnTheFly, (String)"on-the-fly"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"initializeOnce", (boolean)this.m_InitializeOnce, (String)"once"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"lenient", (boolean)this.m_Lenient, (String)"lenient"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"keepRelationName", (boolean)this.m_KeepRelationName, (String)"keep"));
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class, Instances.class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_REFERENCE);
        this.pruneBackup(BACKUP_REORDER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Reference != null) {
            result.put(BACKUP_REFERENCE, this.m_Reference);
        }
        if (this.m_Reorder != null) {
            result.put(BACKUP_REORDER, this.m_Reorder);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_REFERENCE)) {
            this.m_Reference = (Instances)state.get(BACKUP_REFERENCE);
            state.remove(BACKUP_REFERENCE);
        }
        if (state.containsKey(BACKUP_REORDER)) {
            this.m_Reorder = (MultiFilter)state.get(BACKUP_REORDER);
            state.remove(BACKUP_REORDER);
        }
        super.restoreState(state);
    }

    protected String setUpReference() {
        Object result = null;
        if (this.m_ReferenceFile.isDirectory()) {
            try {
                MessageCollection errors = new MessageCollection();
                this.m_Reference = (Instances)CallableActorHelper.getSetupFromSource(null, (CallableActorReference)this.m_ReferenceActor, (Actor)this, (MessageCollection)errors);
                if (this.m_Reference == null && !errors.isEmpty()) {
                    result = errors.toString();
                }
            }
            catch (Exception e) {
                this.m_Reference = null;
                result = this.handleException("Failed to obtain reference from callable actor '" + this.m_ReferenceActor + "': ", e);
            }
        } else {
            try {
                ConverterUtils.DataSource source;
                if (this.m_UseCustomLoader) {
                    AbstractFileLoader loader = this.m_CustomLoader;
                    loader.setFile(this.m_ReferenceFile.getAbsoluteFile());
                    source = new ConverterUtils.DataSource((Loader)loader);
                } else {
                    source = new ConverterUtils.DataSource(this.m_ReferenceFile.getAbsolutePath());
                }
                this.m_Reference = source.getDataSet();
                if (this.m_Reference == null) {
                    result = "Failed to load reference dataset from '" + this.m_ReferenceFile + "'!";
                }
            }
            catch (Exception e) {
                this.m_Reference = null;
                result = this.handleException("Failed to load reference dataset from '" + this.m_ReferenceFile + "': ", e);
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpReference();
        }
        return result;
    }

    protected String doExecute() {
        Instances dataOld;
        Instance instOld;
        Object result = null;
        if (this.m_OnTheFly && this.m_Reference == null && (result = this.setUpReference()) != null) {
            return result;
        }
        Instances dataNew = null;
        Instance instNew = null;
        if (this.m_InputToken.getPayload() instanceof Instance) {
            instOld = (Instance)this.m_InputToken.getPayload();
            dataOld = instOld.dataset();
        } else {
            instOld = null;
            dataOld = (Instances)this.m_InputToken.getPayload();
        }
        if (this.m_InitializeOnce || this.m_Reorder == null) {
            Attribute att;
            int i;
            if (!this.m_Lenient) {
                for (i = 0; i < this.m_Reference.numAttributes(); ++i) {
                    att = this.m_Reference.attribute(i);
                    if (dataOld.attribute(att.name()) != null) continue;
                    result = result == null ? "Missing attribute(s) in incoming data: " + att.name() : (String)result + ", " + att.name();
                }
                if (result != null) {
                    this.getLogger().severe((String)result);
                }
            }
            if (result == null) {
                try {
                    StringBuilder order = new StringBuilder();
                    ArrayList<Add> adds = new ArrayList<Add>();
                    for (i = 0; i < this.m_Reference.numAttributes(); ++i) {
                        int index;
                        att = this.m_Reference.attribute(i);
                        if (dataOld.attribute(att.name()) == null) {
                            index = dataOld.numAttributes() + adds.size();
                            Add add = new Add();
                            add.setAttributeIndex("last");
                            add.setAttributeName(att.name());
                            add.setAttributeType(new SelectedTag(att.type(), Add.TAGS_TYPE));
                            if (att.isNominal()) {
                                StringBuilder labels = new StringBuilder();
                                for (int n = 0; n < att.numValues(); ++n) {
                                    if (labels.length() > 0) {
                                        labels.append(",");
                                    }
                                    labels.append(att.value(n));
                                }
                                add.setNominalLabels(labels.toString());
                            }
                            adds.add(add);
                        } else {
                            index = dataOld.attribute(att.name()).index();
                        }
                        if (order.length() > 0) {
                            order.append(",");
                        }
                        order.append(index + 1);
                    }
                    Reorder reorder = new Reorder();
                    reorder.setAttributeIndices(order.toString());
                    ArrayList<Object> filters = new ArrayList<Object>();
                    filters.addAll(adds);
                    filters.add(reorder);
                    this.m_Reorder = new MultiFilter();
                    this.m_Reorder.setFilters(filters.toArray(new Filter[filters.size()]));
                    this.m_Reorder.setInputFormat(dataOld);
                }
                catch (Exception e) {
                    result = this.handleException("Failed to initialize reorder filter!", e);
                }
            }
        }
        if (result == null) {
            try {
                if (instOld != null) {
                    this.m_Reorder.input(instOld);
                    this.m_Reorder.batchFinished();
                    instNew = this.m_Reorder.output();
                    if (this.m_KeepRelationName) {
                        instNew.dataset().setRelationName(dataOld.relationName());
                    }
                } else {
                    dataNew = Filter.useFilter((Instances)dataOld, (Filter)this.m_Reorder);
                    if (this.m_KeepRelationName) {
                        dataNew.setRelationName(dataOld.relationName());
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to reorder data!", e);
                instNew = null;
                dataNew = null;
            }
        }
        if (instNew != null) {
            this.m_OutputToken = new Token(instNew);
        } else if (dataNew != null) {
            this.m_OutputToken = new Token((Object)dataNew);
        }
        return result;
    }
}

