/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

public class WekaSetInstancesValue
extends AbstractTransformer {
    private static final long serialVersionUID = -4710366291340930250L;
    protected Index m_Row;
    protected WekaAttributeIndex m_Column;
    protected String m_Value;

    public String globalInfo() {
        return "Sets a value in a WEKA Instances object.\nNotes:\n- relational values cannot be set\n- '?' (without single quotes) is interpreted as missing value";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
        this.m_OptionManager.add("column", "column", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("value", "value", (Object)"?");
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Index("first");
        this.m_Column = new WekaAttributeIndex("last");
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The 1-based index of the row.";
    }

    public void setColumn(WekaAttributeIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public WekaAttributeIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to set the value in.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the dataset.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)", row: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)" -> ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        Object result = null;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        inst = new Instances(inst);
        this.m_Row.setMax(inst.numInstances());
        this.m_Column.setData(inst);
        int row = this.m_Row.getIntIndex();
        int index = this.m_Column.getIntIndex();
        if (row == -1) {
            result = "Failed to retrieve row: " + this.m_Row.getIndex();
        } else if (index == -1) {
            result = "Failed to retrieve column: " + this.m_Column.getIndex();
        }
        if (result == null) {
            try {
                if (this.m_Value.equals("?")) {
                    inst.instance(row).setMissing(index);
                } else {
                    switch (inst.attribute(index).type()) {
                        case 0: {
                            inst.instance(row).setValue(index, Utils.toDouble((String)this.m_Value).doubleValue());
                            break;
                        }
                        case 3: {
                            inst.instance(row).setValue(index, inst.attribute(index).parseDate(this.m_Value));
                            break;
                        }
                        case 1: 
                        case 2: {
                            inst.instance(row).setValue(index, this.m_Value);
                            break;
                        }
                        case 4: {
                            result = "Relational attributes cannot be set!";
                            break;
                        }
                        default: {
                            result = "Unhandled attribute type: " + inst.attribute(index).type();
                        }
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to set value: " + this.m_Column.getIndex() + " -> " + this.m_Value, e);
            }
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)inst);
        }
        return result;
    }
}

