/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Stoppable;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.transformer.AbstractArrayProvider;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.SplitGenerator;
import weka.core.Instances;

public class WekaSplitGenerator
extends AbstractArrayProvider {
    private static final long serialVersionUID = -6447945986570354931L;
    protected SplitGenerator m_Generator;
    protected transient SplitGenerator m_ActualGenerator;

    public String globalInfo() {
        return "Splits a dataset into a training and test sets using the specified splitter.\nThe training set can be accessed in the container with 'Train' and the test set with 'Test'.\nDepending on the split generator in use, more than one container may be output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new DefaultRandomSplitGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_ActualGenerator = null;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator);
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected Class getItemClass() {
        return WekaTrainTestSetContainer.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the splits are output as array rather than one-by-one.";
    }

    public void setGenerator(SplitGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public SplitGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the split.";
    }

    protected String doExecute() {
        String result = null;
        Instances inst = new Instances((Instances)this.m_InputToken.getPayload());
        this.m_Queue.clear();
        try {
            this.m_ActualGenerator = (SplitGenerator)ObjectCopyHelper.copyObject((Object)this.m_Generator);
            this.m_ActualGenerator.setData(inst);
        }
        catch (Exception e) {
            this.m_ActualGenerator = null;
            result = this.handleException("Failed to generate split!", e);
        }
        if (result == null) {
            while (this.m_ActualGenerator.hasNext()) {
                this.m_Queue.add(this.m_ActualGenerator.next());
            }
        }
        this.m_ActualGenerator = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_ActualGenerator != null && this.m_ActualGenerator instanceof Stoppable) {
            ((Stoppable)this.m_ActualGenerator).stopExecution();
        }
        super.stopExecution();
    }
}

