/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractCallableWekaClassifierEvaluator;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.core.Instance;
import weka.core.Instances;

public class WekaStreamEvaluator
extends AbstractCallableWekaClassifierEvaluator {
    private static final long serialVersionUID = -1346633748934963999L;
    public static final String BACKUP_CURRENT = "current";
    public static final String BACKUP_HEADER = "header";
    public static final String BACKUP_EVALUATION = "evaluation";
    public static final String BACKUP_CLaSSIFIER = "classifier";
    protected int m_Interval;
    protected int m_Current;
    protected Instances m_Header;
    protected Evaluation m_Evaluation;
    protected Classifier m_Classifier;

    public String globalInfo() {
        return "Evaluates an incremental classifier on a data stream using prequential evaluation (first evaluate, then train).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", (Object)100, (Number)1, null);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Current = 0;
        this.m_Header = null;
        this.m_Evaluation = null;
        this.m_Classifier = null;
    }

    @Override
    public String classifierTipText() {
        return "The callable source with the incremental classifier to evaluate.";
    }

    public void setInterval(int value) {
        if (value >= 1) {
            this.m_Interval = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of interval must be >=1, provided: " + value);
        }
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval (number of instance objects processed) after which to output evaluation or buffer.";
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"interval", (Object)this.m_Interval, (String)", interval: ");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENT);
        this.pruneBackup(BACKUP_HEADER);
        this.pruneBackup(BACKUP_EVALUATION);
        this.pruneBackup(BACKUP_CLaSSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Current > 0) {
            result.put(BACKUP_CURRENT, this.m_Current);
        }
        if (this.m_Header != null) {
            result.put(BACKUP_HEADER, this.m_Header);
        }
        if (this.m_Evaluation != null) {
            result.put(BACKUP_EVALUATION, this.m_Evaluation);
        }
        if (this.m_Classifier != null) {
            result.put(BACKUP_CLaSSIFIER, this.m_Classifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_Current = (Integer)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        if (state.containsKey(BACKUP_HEADER)) {
            this.m_Header = (Instances)state.get(BACKUP_HEADER);
            state.remove(BACKUP_HEADER);
        }
        if (state.containsKey(BACKUP_EVALUATION)) {
            this.m_Evaluation = (Evaluation)state.get(BACKUP_EVALUATION);
            state.remove(BACKUP_EVALUATION);
        }
        if (state.containsKey(BACKUP_CLaSSIFIER)) {
            this.m_Classifier = (Classifier)state.get(BACKUP_CLaSSIFIER);
            state.remove(BACKUP_CLaSSIFIER);
        }
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    @Override
    protected Classifier getClassifierInstance() {
        Classifier result = super.getClassifierInstance();
        if (!(result instanceof UpdateableClassifier)) {
            throw new IllegalStateException("The classifier does not implement " + UpdateableClassifier.class.getName() + "!");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        Instances data = inst.dataset();
        if (this.m_Evaluation == null) {
            try {
                this.m_Evaluation = new Evaluation(data);
                this.m_Current = 0;
                this.m_Header = data;
                this.initOutputBuffer();
                this.m_Output.setHeader(this.m_Header);
            }
            catch (Exception e) {
                result = this.handleException("Failed to set up evaluation!", e);
            }
        }
        if (result == null) {
            try {
                if (this.m_Classifier == null) {
                    this.m_Classifier = this.getClassifierInstance();
                    this.m_Classifier.buildClassifier(data);
                }
                if (this.m_Current > 0) {
                    if (this.m_DiscardPredictions) {
                        this.m_Evaluation.evaluateModelOnce(this.m_Classifier, inst);
                    } else {
                        this.m_Evaluation.evaluateModelOnceAndRecordPrediction(this.m_Classifier, inst);
                    }
                }
                ((UpdateableClassifier)this.m_Classifier).updateClassifier(inst);
            }
            catch (Exception e) {
                result = this.handleException("Failed to evaluate/update the classifier!", e);
            }
        }
        ++this.m_Current;
        if (this.m_Current % this.m_Interval == 0) {
            this.m_OutputToken = this.m_Output instanceof Null ? new Token((Object)new WekaEvaluationContainer(this.m_Evaluation)) : (this.m_AlwaysUseContainer ? new Token((Object)new WekaEvaluationContainer(this.m_Evaluation, null, this.m_Output.getBuffer().toString())) : new Token((Object)this.m_Output.getBuffer().toString()));
        }
        return result;
    }
}

