/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaClusterEvaluationContainer;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.CallableSource;
import adams.flow.transformer.AbstractTransformer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Instances;

public class WekaTestSetClustererEvaluator
extends AbstractTransformer {
    private static final long serialVersionUID = -8528709957864675275L;
    protected CallableActorReference m_Testset;
    protected boolean m_OutputModel;

    public String globalInfo() {
        return "Evaluates a trained clusterer (obtained from input) on the dataset obtained from the callable actor.\nIf a class attribute is set, a classes-to-clusters evaluation is performed automatically";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("testset", "testset", (Object)new CallableActorReference("Testset"));
        this.m_OptionManager.add("output-model", "outputModel", (Object)false);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"testset", (Object)this.m_Testset);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputModel", (boolean)this.m_OutputModel, (String)"output model", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setTestset(CallableActorReference value) {
        this.m_Testset = value;
        this.reset();
    }

    public CallableActorReference getTestset() {
        return this.m_Testset;
    }

    public String testsetTipText() {
        return "The callable actor to use for obtaining the test set.";
    }

    public void setOutputModel(boolean value) {
        this.m_OutputModel = value;
        this.reset();
    }

    public boolean getOutputModel() {
        return this.m_OutputModel;
    }

    public String outputModelTipText() {
        return "If enabled, the clusterer model is output as well.";
    }

    public Class[] accepts() {
        return new Class[]{Clusterer.class, WekaModelContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaClusterEvaluationContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Instances test = null;
            CallableSource gs = new CallableSource();
            gs.setCallableName(this.m_Testset);
            gs.setParent(this.getParent());
            gs.setUp();
            gs.execute();
            Token output = gs.output();
            if (output != null) {
                test = (Instances)output.getPayload();
            } else {
                result = "No test set available!";
            }
            gs.wrapUp();
            if (result == null) {
                Clusterer cls = this.m_InputToken.getPayload() instanceof Clusterer ? (Clusterer)this.m_InputToken.getPayload() : (Clusterer)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model");
                ClusterEvaluation eval = new ClusterEvaluation();
                eval.setClusterer(cls);
                eval.evaluateClusterer(test, null, this.m_OutputModel);
                this.m_OutputToken = new Token((Object)new WekaClusterEvaluationContainer(eval, cls));
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        return result;
    }
}

