/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.indexedsplitsrunsgenerator;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.binning.BinnableInstances;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import adams.data.indexedsplits.IndexedSplit;
import adams.data.indexedsplits.IndexedSplits;
import adams.data.indexedsplits.IndexedSplitsRun;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.SplitIndices;
import adams.data.splitgenerator.generic.core.Subset;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.data.splitgenerator.generic.splitter.Splitter;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.transformer.indexedsplitsrunsgenerator.AbstractInstancesIndexedSplitsRunsGenerator;
import com.github.fracpete.javautils.struct.Struct2;
import gnu.trove.list.TIntList;
import java.util.Collection;
import java.util.List;
import weka.core.Instances;

public class InstancesGroupedRandomSplitGenerator
extends AbstractInstancesIndexedSplitsRunsGenerator
implements Randomizable {
    private static final long serialVersionUID = -845552507613381226L;
    protected double m_Percentage;
    protected long m_Seed;
    protected boolean m_PreserveOrder;
    protected WekaAttributeIndex m_Index;
    protected BaseRegExp m_RegExp;
    protected String m_Group;

    public String globalInfo() {
        return "Random split generator that works on Instances objects.\nEnsures that groups of instances stay together, determined via a regular expression (eg '^(.*)-([0-9]+)-(.*)$') and a group replacement string (eg '$2').";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("first"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("group", "group", (Object)"$0");
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage to use for training (0-1).";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the order in the data is preserved in the split.";
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The percentage to use for training (0-1).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the group (eg '^(.*)-([0-9]+)-(.*)$').";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The replacement string to use as group (eg '$2').";
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage, (String)", percentage: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (Object)(this.m_PreserveOrder ? "preserve order" : "randomize"), (String)", ");
        if (!this.m_PreserveOrder) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)((Object)this.m_Index), (String)", index: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", regexp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"group", (Object)this.m_Group, (String)", group: ");
        return result;
    }

    protected IndexedSplitsRuns doGenerate(Object data, MessageCollection errors) {
        List binnableGroups;
        PassThrough rand;
        Instances instances = (Instances)data;
        RandomSplitGenerator generator = new RandomSplitGenerator();
        if (this.m_PreserveOrder) {
            rand = new PassThrough();
            generator.setRandomization((Randomization)rand);
        } else {
            rand = new DefaultRandomization();
            rand.setSeed(this.m_Seed);
            generator.setRandomization((Randomization)rand);
        }
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(this.m_Percentage);
        generator.setSplitter((Splitter)splitter);
        try {
            this.m_Index.setData(instances);
            List binnableInst = BinnableInstances.toBinnableUsingIndex(instances);
            binnableInst = Wrapping.addTmpIndex(binnableInst);
            List groupedInst = Grouping.groupAsList((List)binnableInst, (Grouping.GroupExtractor)new BinnableInstances.StringAttributeGroupExtractor(this.m_Index.getIntIndex(), this.m_RegExp.getValue(), this.m_Group));
            binnableGroups = Wrapping.wrap((Collection)groupedInst, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create binnable instances!", e);
        }
        SplitPair splitGroups = generator.generate(binnableGroups);
        Struct2 subsetTrain = Subset.extractIndicesAndBinnable((Subset)splitGroups.getTrain());
        Struct2 subsetTest = Subset.extractIndicesAndBinnable((Subset)splitGroups.getTest());
        int[] trainRows = ((TIntList)subsetTrain.value1).toArray();
        int[] testRows = ((TIntList)subsetTest.value1).toArray();
        IndexedSplit indexedSplit = new IndexedSplit(0);
        indexedSplit.add(new SplitIndices("train", trainRows));
        indexedSplit.add(new SplitIndices("test", testRows));
        IndexedSplits indexedSplits = new IndexedSplits();
        indexedSplits.add((Object)indexedSplit);
        IndexedSplitsRun indexedSplitsRun = new IndexedSplitsRun(0, indexedSplits);
        IndexedSplitsRuns result = new IndexedSplitsRuns();
        result.add((Object)indexedSplitsRun);
        return result;
    }
}

