/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.flow.container.WekaModelContainer;
import adams.flow.transformer.wekaclusterer.AbstractClustererPostProcessor;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiClustererPostProcessor
extends AbstractClustererPostProcessor {
    private static final long serialVersionUID = 3138007350708781436L;
    protected AbstractClustererPostProcessor[] m_PostProcessors;

    public String globalInfo() {
        return "Applies the specified post-processors sequentially.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessors", (Object)new AbstractClustererPostProcessor[0]);
    }

    public void setPostProcessors(AbstractClustererPostProcessor[] value) {
        this.m_PostProcessors = value;
        this.reset();
    }

    public AbstractClustererPostProcessor[] getPostProcessors() {
        return this.m_PostProcessors;
    }

    public String postProcessorsTipText() {
        return "The post-processors to apply sequentially.";
    }

    @Override
    protected String[] getContainerKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractClustererPostProcessor p : this.m_PostProcessors) {
            result.addAll(Arrays.asList(p.getContainerKeys()));
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected WekaModelContainer doPostProcess(WekaModelContainer cont) {
        for (AbstractClustererPostProcessor p : this.m_PostProcessors) {
            cont = p.postProcess(cont);
        }
        return cont;
    }
}

