/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaensemblegenerator;

import adams.core.ObjectCopyHelper;
import adams.core.Utils;
import adams.flow.transformer.wekaensemblegenerator.AbstractWekaEnsembleGenerator;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Vote;

public class VotedModels
extends AbstractWekaEnsembleGenerator {
    private static final long serialVersionUID = -7876743086471307294L;
    protected Vote m_Template;

    public String globalInfo() {
        return "Generates a Vote meta-classifier from the incoming pre-built classifier models.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "template", (Object)new Vote());
    }

    public void setTemplate(Vote value) {
        this.m_Template = value;
        this.reset();
    }

    public Vote getTemplate() {
        return this.m_Template;
    }

    public String voteTipText() {
        return "The template of the Vote classifier to use.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Classifier[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Vote.class};
    }

    @Override
    protected String check(Object input) {
        Object result = super.check(input);
        if (result == null && !(input instanceof Classifier[])) {
            result = "Input does not represent a classifier array (" + Utils.classToString(Classifier[].class) + ")!";
        }
        return result;
    }

    @Override
    protected Object doGenerate(Object input) {
        Classifier[] classifiers = (Classifier[])input;
        Vote result = (Vote)ObjectCopyHelper.copyObject((Object)this.m_Template);
        result.setClassifiers(classifiers);
        return result;
    }
}

