/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.weka;

import adams.core.Properties;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.WekaSelectDatasetPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;

public class AppendDatasetsPanel
extends BasePanel {
    private static final long serialVersionUID = -1965973872146968486L;
    protected WizardPane m_Wizard;
    protected boolean m_CloseParent;

    public AppendDatasetsPanel(boolean closeParent) {
        this.m_CloseParent = closeParent;
    }

    protected void initGUI() {
        super.initGUI();
        this.m_Wizard = new WizardPane();
        this.add((Component)this.m_Wizard, "Center");
        this.m_Wizard.setCustomFinishText("Append");
        WekaSelectMultipleDatasetsPage infiles = new WekaSelectMultipleDatasetsPage("Input");
        infiles.setDescription("Select the Weka datasets to append (one-after-the-other).\nYou have to choose at least two.");
        infiles.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length >= 2;
                }
                catch (Exception e) {
                    ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to obtain files:", (Throwable)e);
                    return false;
                }
            }
        });
        this.m_Wizard.addPage((AbstractWizardPage)infiles);
        WekaSelectDatasetPage outfile = new WekaSelectDatasetPage("Output");
        outfile.setDescription("Select the file to save the combined data to.");
        outfile.setUseSaveDialog(true);
        this.m_Wizard.addPage((AbstractWizardPage)outfile);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Append</b> to start the process.</html>");
        this.m_Wizard.addPage((AbstractWizardPage)finalpage);
        this.m_Wizard.addActionListener(e -> {
            if (!e.getActionCommand().equals("Finish")) {
                if (this.m_CloseParent) {
                    this.closeParent();
                }
                return;
            }
            Properties props = this.m_Wizard.getProperties(false);
            File[] input = null;
            File output = null;
            try {
                String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                input = new File[files.length];
                for (int i = 0; i < files.length; ++i) {
                    input[i] = new File(files[i]);
                }
                output = new File(props.getProperty("file"));
            }
            catch (Exception ex) {
                GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to get setup from wizard!\n" + LoggingHelper.throwableToString((Throwable)ex)));
                return;
            }
            this.doAppend(input, output);
        });
        this.m_Wizard.update();
    }

    protected void doAppend(File[] input, File output) {
        int n;
        int i;
        if (input.length < 2) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)"At least two files are required!");
            return;
        }
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)input[0]);
        Instances[] data = new Instances[input.length];
        int count = 0;
        TIntArrayList transferAtt = new TIntArrayList();
        for (i = 0; i < input.length; ++i) {
            try {
                loader.setFile(input[i]);
                data[i] = ConverterUtils.DataSource.read((Loader)loader);
                if (i > 0) {
                    if (!data[0].equalHeaders(data[i])) {
                        GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Datasets '" + input[0] + "' and '" + input[i] + "' are not compatible!\n" + data[0].equalHeadersMsg(data[i])));
                        return;
                    }
                } else {
                    for (n = 0; n < data[0].numAttributes(); ++n) {
                        if (!data[0].attribute(n).isString() && !data[0].attribute(n).isRelationValued()) continue;
                        transferAtt.add(n);
                    }
                }
                count += data[i].numInstances();
                continue;
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to read '" + input[i] + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
                return;
            }
        }
        Instances full = new Instances(data[0], count);
        for (i = 0; i < data.length; ++i) {
            for (Instance inst : data[i]) {
                if (transferAtt.size() > 0) {
                    for (n = 0; n < transferAtt.size(); ++n) {
                        int index = transferAtt.get(n);
                        if (inst.attribute(index).isString()) {
                            full.attribute(index).addStringValue(inst.stringValue(index));
                            continue;
                        }
                        if (inst.attribute(n).isRelationValued()) {
                            full.attribute(index).addRelation(inst.relationalValue(index));
                            continue;
                        }
                        throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((Attribute)inst.attribute(index)));
                    }
                }
                full.add(inst);
            }
        }
        try {
            ConverterUtils.DataSink sink = new ConverterUtils.DataSink(output.getAbsolutePath());
            sink.write(full);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Failed to save data to '" + output + "'!\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        GUIHelper.showInformationMessage(null, (String)("Successfully appended!\n" + output));
        if (this.m_CloseParent) {
            this.closeParent();
        }
    }
}

