/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator;

import adams.core.MessageCollection;
import adams.core.UniqueIDs;
import adams.env.Environment;
import adams.gui.core.BaseFrame;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorWorkspaceHelper;
import adams.gui.tools.wekainvestigator.InvestigatorWorkspaceList;
import adams.gui.workspace.AbstractSerializableWorkspaceManagerPanel;
import adams.gui.workspace.AbstractWorkspaceListPanel;
import adams.gui.workspace.AbstractWorkspaceManagerPanel;
import adams.gui.workspace.AbstractWorkspacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class InvestigatorManagerPanel
extends AbstractSerializableWorkspaceManagerPanel<InvestigatorPanel> {
    private static final long serialVersionUID = -5959114946146695938L;

    protected String getDefaultWorkspaceName() {
        return "Session";
    }

    protected InvestigatorPanel newWorkspace(boolean init) {
        InvestigatorPanel result = new InvestigatorPanel();
        if (init) {
            result.addDefaultTabs();
        }
        return result;
    }

    protected InvestigatorWorkspaceHelper newWorkspaceHelper() {
        return new InvestigatorWorkspaceHelper();
    }

    protected void copyWorkspace() {
        String nameOld = this.getHistory().getSelectedEntry();
        String nameNew = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter name for workspace", (String)(nameOld + " (" + UniqueIDs.nextInt((String)"WekaInvestigatorPanel") + ")"));
        if (nameNew == null) {
            return;
        }
        if (nameNew.equals(nameOld)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"No new name for workspace supplied, aborting!");
            return;
        }
        if (this.m_History.hasEntry(nameNew)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"Workspace name already present, aborting!");
            return;
        }
        try {
            MessageCollection errors = new MessageCollection();
            InvestigatorPanel panelOld = (InvestigatorPanel)((Object)this.m_History.getEntry(nameOld));
            InvestigatorPanel panelNew = (InvestigatorPanel)this.m_WorkspaceHelper.copy((AbstractWorkspaceManagerPanel)this, (AbstractWorkspacePanel)panelOld, errors);
            this.m_History.addEntry(nameNew, (Object)panelNew);
            this.m_History.setSelectedEntry(nameNew);
            if (!errors.isEmpty()) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to copy workspace!\n" + errors));
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"Failed to copy workspace!", (Throwable)e);
        }
    }

    protected AbstractWorkspaceListPanel<InvestigatorPanel> newWorkspaceList() {
        return new InvestigatorWorkspaceList();
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        final InvestigatorManagerPanel panel = new InvestigatorManagerPanel();
        BaseFrame frame = new BaseFrame("Investigator");
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                panel.cleanUp();
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)panel), "Center");
        frame.setSize(GUIHelper.makeWider((Dimension)GUIHelper.getDefaultLargeDialogDimension()));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

