/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import weka.core.Instances;

public class Copy
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Copy() {
        this.setName("Copy");
        this.setIcon("copy.gif");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Copying dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        String newName = GUIHelper.showInputDialog((Component)((Object)this.getOwner()), (String)"Please enter new relation name: ", (String)("Copy of " + cont.getData().relationName()));
        if (newName == null) {
            this.logMessage("Copying cancelled!");
            return;
        }
        MemoryContainer newCont = new MemoryContainer(new Instances(cont.getData()));
        newCont.getData().setRelationName(newName);
        this.getData().add(newCont);
        this.logMessage("Successfully copied " + cont.getID() + "/" + cont.getData().relationName() + " to " + newCont.getID() + "/" + newCont.getData().relationName() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, this.getData().size() - 1));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

