/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.evaluation;

import adams.gui.tools.wekainvestigator.data.DataContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;

public class DatasetHelper {
    public static boolean hasDataChanged(List<String> newDatasets, ComboBoxModel<String> currentModel) {
        boolean result;
        int i;
        HashSet<String> setDatasets = new HashSet<String>(newDatasets);
        HashSet<String> setModel = new HashSet<String>();
        for (i = 0; i < currentModel.getSize(); ++i) {
            setModel.add((String)currentModel.getElementAt(i));
        }
        boolean bl = result = setDatasets.size() != setModel.size() || !setDatasets.containsAll(setModel) || !setModel.containsAll(setDatasets);
        if (!result) {
            for (i = 0; i < newDatasets.size(); ++i) {
                if (newDatasets.get(i).equals(currentModel.getElementAt(i))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static int indexOfDataset(List<DataContainer> conts, String oldDataset) {
        int result = -1;
        if (oldDataset != null) {
            DataContainer data;
            int i;
            int id;
            String idStr = oldDataset.replaceAll(":.*", "");
            try {
                id = Integer.parseInt(idStr);
            }
            catch (Exception e) {
                id = -1;
            }
            for (i = 0; i < conts.size(); ++i) {
                data = conts.get(i);
                if (data.getID() != id) continue;
                result = i;
                break;
            }
            if (result == -1) {
                oldDataset = oldDataset.replaceAll("^[0-9]+: ", "");
                for (i = 0; i < conts.size(); ++i) {
                    data = conts.get(i);
                    if (!data.getData().relationName().equals(oldDataset)) continue;
                    result = i;
                    break;
                }
            }
        }
        return result;
    }

    public static List<String> generateDatasetList(List<DataContainer> conts) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < conts.size(); ++i) {
            DataContainer data = conts.get(i);
            result.add(data.getID() + ": " + data.getData().relationName());
        }
        return result;
    }
}

