/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.job;

import adams.gui.tools.wekainvestigator.InvestigatorPanel;

public abstract class InvestigatorJob
implements Runnable {
    protected InvestigatorPanel m_Owner;
    protected String m_Title;

    public InvestigatorJob(InvestigatorPanel owner, String title) {
        this.m_Owner = owner;
        this.m_Title = title;
    }

    public InvestigatorPanel getOwner() {
        return this.m_Owner;
    }

    public String getTitle() {
        return this.m_Title;
    }

    protected void preRun() {
        this.m_Owner.logAndShowMessage(this.m_Title);
    }

    protected abstract void doRun();

    protected void postRun() {
        this.m_Owner.executionFinished();
    }

    @Override
    public void run() {
        this.preRun();
        try {
            this.doRun();
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable t) {
            this.m_Owner.logError("Failed to execute job:\n" + this.m_Title, t, "Job error");
        }
        this.postRun();
    }
}

